/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionCategories;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionCategory;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionSubcategories;
import it.hurts.sskirillss.relics.api.relics.description.DescriptionSubcategory;
import it.hurts.sskirillss.relics.badges.base.RelicBadge;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IPagedDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.base.ITabbedDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.RelicBadgeWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.ScrollbarWidget;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.BigRelicCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.DescriptionContainerWidget;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.RankupRelicActionWidget;
import it.hurts.sskirillss.relics.init.RelicsBadges;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;

@OnlyIn(value=Dist.CLIENT)
public class RelicDescriptionScreen
extends DescriptionScreen
implements ITabbedDescriptionScreen,
IPagedDescriptionScreen {
    private DescriptionSubcategory subcategory = DescriptionSubcategories.getSubcategory("relic_description");

    public RelicDescriptionScreen(Player player, int container, int slot, Screen screen) {
        super(player, container, slot, screen);
    }

    @Override
    protected void init() {
        Item item;
        super.init();
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        int xOff = 0;
        this.addRenderableWidget((GuiEventListener)new BigRelicCardWidget(this.x + 59, this.y + 43, this));
        for (RelicBadge badge : RelicsBadges.BADGES.getEntries().stream().map(DeferredHolder::get).filter(entry -> entry instanceof RelicBadge).map(entry -> (RelicBadge)entry).toList()) {
            if (!badge.isVisible((LivingEntity)this.minecraft.player, this.stack)) continue;
            this.addRenderableWidget((GuiEventListener)new RelicBadgeWidget(this.x + 260 - xOff, this.y + 54, (DescriptionScreen)this, badge));
            xOff += 15;
        }
        DescriptionContainerWidget container = this.subcategory.getContainerWidget(this);
        this.addRenderableWidget((GuiEventListener)container);
        this.addRenderableWidget((GuiEventListener)new ScrollbarWidget(this.x + 279, this.y + 74, container));
        this.addRenderableWidget((GuiEventListener)new RankupRelicActionWidget(this.x + 289, this.y + 84, this));
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.scale(0.75f, 0.75f, 1.0f);
        guiGraphics.drawString(this.minecraft.font, (Component)Component.literal((String)this.stack.getDisplayName().getString().replace("[", "").replace("]", "")).withStyle(ChatFormatting.BOLD), (int)((float)(this.x + 114) * 1.33f), (int)((float)(this.y + 62) * 1.33f), 7548704, false);
        poseStack.popPose();
        poseStack.pushPose();
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/general/top_background_delimiter.png"), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.x + 107, this.y + 70).end();
        poseStack.popPose();
    }

    public static List<FormattedCharSequence> justifyStyledText(Component text, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        StringSplitter splitter = font.getSplitter();
        ArrayList words = new ArrayList();
        text.visit((style, str) -> {
            for (String token : str.split(" ", -1)) {
                if (token.isEmpty()) {
                    words.add(FormattedText.of((String)" ", (Style)style));
                    continue;
                }
                words.add(FormattedText.of((String)token, (Style)style));
            }
            return Optional.empty();
        }, Style.EMPTY);
        ArrayList<FormattedCharSequence> result = new ArrayList<FormattedCharSequence>();
        ArrayList<FormattedText> line = new ArrayList<FormattedText>();
        float lineWidth = 0.0f;
        for (FormattedText word : words) {
            float wordWidth = splitter.stringWidth(word) + (float)font.width(" ");
            if (lineWidth + wordWidth > (float)maxWidth && !line.isEmpty()) {
                if (line.size() == 1) {
                    result.add(Language.getInstance().getVisualOrder((FormattedText)line.getFirst()));
                } else {
                    float totalWordsWidth = line.stream().map(arg_0 -> ((StringSplitter)splitter).stringWidth(arg_0)).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
                    int gaps = line.size() - 1;
                    float totalSpacing = (float)maxWidth - totalWordsWidth;
                    int baseSpaces = (int)(totalSpacing / (float)font.width(" "));
                    int extra = (int)(totalSpacing % (float)font.width(" "));
                    ArrayList<FormattedText> parts = new ArrayList<FormattedText>();
                    for (int i = 0; i < line.size(); ++i) {
                        parts.add((FormattedText)line.get(i));
                        if (i >= gaps) continue;
                        int count = baseSpaces / gaps + (i < baseSpaces % gaps ? 1 : 0);
                        parts.add(FormattedText.of((String)" ".repeat(Math.max(1, count))));
                    }
                    result.add(Language.getInstance().getVisualOrder(FormattedText.composite(parts)));
                }
                line.clear();
                lineWidth = 0.0f;
            }
            line.add(word);
            lineWidth += wordWidth;
        }
        if (!line.isEmpty()) {
            ArrayList<FormattedText> parts = new ArrayList<FormattedText>();
            for (int i = 0; i < line.size(); ++i) {
                parts.add((FormattedText)line.get(i));
                if (i >= line.size() - 1) continue;
                parts.add(FormattedText.of((String)" "));
            }
            result.add(Language.getInstance().getVisualOrder(FormattedText.composite(parts)));
        }
        return result;
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.children()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).isHovered() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void onClose() {
        this.screen.rebuildWidgets();
        Minecraft.getInstance().setScreen(this.screen);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public DescriptionCategory getCategory() {
        return DescriptionCategories.getCategory("relic");
    }

    @Override
    @Generated
    public DescriptionSubcategory getSubcategory() {
        return this.subcategory;
    }

    @Override
    @Generated
    public void setSubcategory(DescriptionSubcategory subcategory) {
        this.subcategory = subcategory;
    }
}

