/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.ScrollbarWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.DescriptionContainerWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.utils.data.GUIScissors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AbilityDescriptionContainerWidget
extends DescriptionContainerWidget {
    private static final int TEXT_OFFSET = 2;
    private static final int VERTICAL_PADDING = 1;

    public AbilityDescriptionContainerWidget(DescriptionScreen screen) {
        super(screen);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        LocalPlayer player = this.minecraft.player;
        AbilityDescriptionScreen screen = (AbilityDescriptionScreen)this.getScreen();
        ItemStack stack = screen.getStack();
        if (stack == null || !(stack.getItem() instanceof IRelicItem) || player == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        GUIScissors.begin(this.getX(), this.getY() - 1, this.getWidth(), this.getHeight() + 1);
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        DescriptionData data = this.constructDescriptionData();
        List<LayoutLine> layout = this.layoutJustifiedLines(this.minecraft.font, data.rawLines(), data.dynamicComponents(), 320);
        ScrollbarWidget scroll = this.getScrollbar();
        if (scroll != null) {
            Objects.requireNonNull(this.minecraft.font);
            int lineStep = 9 + 1;
            int totalLines = layout.size();
            int overflowLines = Math.max(0, totalLines - 9);
            int maxScrollPx = overflowLines * lineStep + 3;
            double offset = scroll.getScrollPosition(partialTick);
            double shiftY = offset * (double)maxScrollPx;
            poseStack.translate(0.0, -shiftY, 0.0);
        }
        this.renderJustifiedDescriptionWithStatBoxes(guiGraphics, (this.getX() + 7) * 2, this.getY() * 2, 320, this.minecraft.font, layout);
        poseStack.popPose();
        GUIScissors.end();
    }

    public DescriptionData constructDescriptionData() {
        Item item;
        LocalPlayer player = this.minecraft.player;
        AbilityDescriptionScreen screen = (AbilityDescriptionScreen)this.getScreen();
        ItemStack stack = screen.getStack();
        String ability = screen.getSelectedAbility();
        if (player == null || stack == null || !((item = stack.getItem()) instanceof IRelicItem)) {
            return new DescriptionData(List.of(), List.of());
        }
        IRelicItem relic = (IRelicItem)item;
        AbilityTemplate template = relic.getAbilityTemplate((LivingEntity)player, stack, ability);
        int level = relic.getAbilityLevel((LivingEntity)player, stack, ability);
        boolean wantsUpgrade = screen.getUpgradeButton() != null && screen.getUpgradeButton().isHovered() && relic.mayUpgrade((LivingEntity)player, stack, ability);
        boolean wantsReroll = screen.getRerollButton() != null && screen.getRerollButton().isHovered() && relic.mayReroll((LivingEntity)player, stack, ability);
        boolean wantsReset = screen.getResetButton() != null && screen.getResetButton().isHovered() && relic.mayReset((LivingEntity)player, stack, ability);
        List<MutableComponent> dynamicComponents = template.getStats().values().stream().map(stat -> {
            double rawValue = relic.getStatValueForLevel((LivingEntity)player, stack, ability, stat.getId(), wantsUpgrade ? level + 1 : (wantsReset ? 0 : level));
            String txt = stat.getFormatValue().apply(rawValue).toString();
            if (txt.endsWith(".0")) {
                txt = txt.substring(0, txt.length() - 2);
            }
            MutableComponent result = Component.literal((String)txt).withStyle(ChatFormatting.BOLD).withColor(wantsUpgrade ? DescriptionUtils.POSITIVE_COLOR(true) : (wantsReroll ? DescriptionUtils.NEUTRAL_COLOR(true) : (wantsReset ? DescriptionUtils.NEGATIVE_COLOR(true) : 7548704)));
            if (wantsReroll) {
                result = result.withStyle(ChatFormatting.OBFUSCATED);
            }
            return result;
        }).toList();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        String key = "relics.description." + itemId + ".ability." + ability + "." + (String)(relic.getAbilityTemplate((LivingEntity)player, stack, ability).getModes().isEmpty() ? "description" : relic.getAbilityMode((LivingEntity)player, stack, ability) + ".description");
        String[] tokens = (String[])IntStream.rangeClosed(1, dynamicComponents.size()).mapToObj(i -> "%" + i + "$s").toArray(String[]::new);
        MutableComponent descriptionComponent = Component.translatable((String)key, (Object[])tokens);
        ArrayList<LineEntry> rawLines = new ArrayList<LineEntry>();
        rawLines.add(new LineEntry(descriptionComponent, true));
        for (Map.Entry entry : template.getRankModifiers().entries()) {
            rawLines.add(new LineEntry(Component.literal((String)""), false));
            rawLines.add(new LineEntry(Component.translatable((String)"relics.description.ability.rank_modifier.condition.rank", (Object[])new Object[]{entry.getKey()}).withStyle(ChatFormatting.BOLD), false));
            MutableComponent description = Component.literal((String)"\u25cf ").append((Component)Component.translatable((String)("relics.description." + itemId + ".ability." + ability + ".rank_modifier." + (String)entry.getValue()), (Object[])tokens));
            if (relic.getRelicRank((LivingEntity)player, stack) < (Integer)entry.getKey()) {
                description = ScreenUtils.randomizeAllCharacters(description, this.hashCode()).withStyle(Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(DescriptionUtils.NEGATIVE_COLOR(true)));
            }
            rawLines.add(new LineEntry(description, true));
        }
        if (!relic.isAbilityUnlocked((LivingEntity)player, stack, ability)) {
            for (LineEntry line : rawLines) {
                line.setRawLine(ScreenUtils.randomizeAllCharacters(line.getRawLine(), this.hashCode()).withStyle(Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(DescriptionUtils.NEGATIVE_COLOR(true))));
            }
        }
        return new DescriptionData(rawLines, dynamicComponents);
    }

    public List<LayoutLine> layoutJustifiedLines(Font font, List<LineEntry> rawLineEntries, List<MutableComponent> dynamicComponents, int maximumLineWidth) {
        StringSplitter splitter = font.getSplitter();
        int spaceWidth = (int)Math.ceil(splitter.stringWidth(FormattedText.of((String)" ", (Style)Style.EMPTY)));
        Pattern placeholderPattern = Pattern.compile("([()%]*%(\\d+)\\$s[()%]*)");
        ArrayList<LayoutLine> result = new ArrayList<LayoutLine>();
        for (LineEntry entry : rawLineEntries) {
            String rawText = entry.getRawLine().getString();
            if (rawText.isEmpty()) {
                result.add(new LayoutLine(List.of(), false));
                continue;
            }
            ArrayList<Word> words = new ArrayList<Word>();
            Matcher matcher = placeholderPattern.matcher(rawText);
            int lastEnd = 0;
            while (matcher.find()) {
                if (matcher.start() > lastEnd) {
                    String before = rawText.substring(lastEnd, matcher.start());
                    Arrays.stream(before.split(" ")).filter(tok -> !tok.isEmpty()).forEach(tok -> words.add(new Word(Component.literal((String)tok).withStyle(entry.getRawLine().getStyle()), false)));
                }
                String segment = matcher.group(1);
                int index = Integer.parseInt(matcher.group(2)) - 1;
                MutableComponent dynamicComponent = dynamicComponents.get(index).copy();
                Style style = dynamicComponent.getStyle();
                String prefix = segment.substring(0, segment.indexOf(37));
                String suffix = segment.substring(segment.lastIndexOf(115) + 1);
                if (!prefix.isEmpty()) {
                    dynamicComponent = Component.literal((String)prefix).withStyle(style).append((Component)dynamicComponent);
                }
                if (!suffix.isEmpty()) {
                    dynamicComponent.append((Component)Component.literal((String)suffix).withStyle(style));
                }
                words.add(new Word(dynamicComponent, true));
                lastEnd = matcher.end();
            }
            if (lastEnd < rawText.length()) {
                String after = rawText.substring(lastEnd);
                Arrays.stream(after.split(" ")).filter(tok -> !tok.isEmpty()).forEach(tok -> words.add(new Word(Component.literal((String)tok).withStyle(entry.getRawLine().getStyle()), false)));
            }
            ArrayList lines = new ArrayList();
            ArrayList<Word> current = new ArrayList<Word>();
            int used = 0;
            for (Word word : words) {
                int wordWidth = (int)Math.ceil(splitter.stringWidth(FormattedText.of((String)word.component.getString(), (Style)word.component.getStyle()))) + (word.isDynamic ? 4 : 0);
                if (!current.isEmpty() && used + wordWidth + spaceWidth > maximumLineWidth) {
                    lines.add(current);
                    current = new ArrayList();
                    used = 0;
                }
                current.add(word);
                used += wordWidth + spaceWidth;
            }
            if (!current.isEmpty()) {
                lines.add(current);
            }
            for (int i = 0; i < lines.size(); ++i) {
                boolean justifyLine = entry.isJustify() && i < lines.size() - 1;
                result.add(new LayoutLine((List)lines.get(i), justifyLine));
            }
        }
        return result;
    }

    public void renderJustifiedDescriptionWithStatBoxes(GuiGraphics graphics, int startX, int startY, int maximumLineWidth, Font font, List<LayoutLine> layoutLines) {
        StringSplitter splitter = font.getSplitter();
        int spaceWidth = (int)Math.ceil(splitter.stringWidth(FormattedText.of((String)" ", (Style)Style.EMPTY)));
        int y = startY;
        Objects.requireNonNull(font);
        int lineHeight = 9;
        for (LayoutLine line : layoutLines) {
            List<Word> words = line.words();
            if (words.isEmpty()) {
                y += lineHeight + 1;
                continue;
            }
            boolean justify = line.justify();
            int totalW = words.stream().mapToInt(w -> (int)Math.ceil(splitter.stringWidth((FormattedText)w.component)) + (w.isDynamic ? 4 : 0)).sum();
            int gaps = Math.max(1, words.size() - 1);
            int extra = justify ? maximumLineWidth - totalW : spaceWidth * gaps;
            int base = extra / gaps;
            int rem = extra % gaps;
            int x = startX;
            for (int i = 0; i < words.size(); ++i) {
                int color;
                Word word = words.get(i);
                MutableComponent component = word.component;
                int textWidth = (int)Math.ceil(splitter.stringWidth((FormattedText)component));
                Style style = component.getStyle();
                int n = color = style.getColor() != null ? style.getColor().getValue() : 7548704;
                if (word.isDynamic) {
                    graphics.fill(x - 1, y - 1, x + textWidth + 4, y, 0xFF000000 | color);
                    graphics.fill(x - 1, y + lineHeight, x + textWidth + 4, y + lineHeight + 1, 0xFF000000 | color);
                    graphics.fill(x - 1, y - 1, x, y + lineHeight + 1, 0xFF000000 | color);
                    graphics.fill(x + textWidth + 3, y - 1, x + textWidth + 4, y + lineHeight + 1, 0xFF000000 | color);
                    graphics.drawString(font, Language.getInstance().getVisualOrder((FormattedText)component), x + 2, y + 1, color, false);
                    x += textWidth + 5;
                } else {
                    graphics.drawString(font, Language.getInstance().getVisualOrder((FormattedText)component), x, y, color, false);
                    x += textWidth;
                }
                if (i >= words.size() - 1) continue;
                x += base + (i < rem ? 1 : 0);
            }
            y += lineHeight + 1;
        }
    }

    @Override
    public int getContentHeight() {
        DescriptionData data = this.constructDescriptionData();
        List<LayoutLine> lines = this.layoutJustifiedLines(this.minecraft.font, data.rawLines(), data.dynamicComponents(), 320);
        Objects.requireNonNull(this.minecraft.font);
        int step = 9 + 1;
        return lines.size() * step / 2 + 6;
    }

    public record DescriptionData(List<LineEntry> rawLines, List<MutableComponent> dynamicComponents) {
    }

    private static class LineEntry {
        private MutableComponent rawLine;
        private boolean justify;

        @Generated
        public MutableComponent getRawLine() {
            return this.rawLine;
        }

        @Generated
        public boolean isJustify() {
            return this.justify;
        }

        @Generated
        public void setRawLine(MutableComponent rawLine) {
            this.rawLine = rawLine;
        }

        @Generated
        public void setJustify(boolean justify) {
            this.justify = justify;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineEntry)) {
                return false;
            }
            LineEntry other = (LineEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isJustify() != other.isJustify()) {
                return false;
            }
            MutableComponent this$rawLine = this.getRawLine();
            MutableComponent other$rawLine = other.getRawLine();
            return !(this$rawLine == null ? other$rawLine != null : !this$rawLine.equals(other$rawLine));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LineEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isJustify() ? 79 : 97);
            MutableComponent $rawLine = this.getRawLine();
            result = result * 59 + ($rawLine == null ? 43 : $rawLine.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbilityDescriptionContainerWidget.LineEntry(rawLine=" + String.valueOf(this.getRawLine()) + ", justify=" + this.isJustify() + ")";
        }

        @Generated
        public LineEntry(MutableComponent rawLine, boolean justify) {
            this.rawLine = rawLine;
            this.justify = justify;
        }
    }

    public record LayoutLine(List<Word> words, boolean justify) {
    }

    private static class Word {
        final MutableComponent component;
        final boolean isDynamic;

        Word(MutableComponent component, boolean isDynamic) {
            this.component = component;
            this.isDynamic = isDynamic;
        }
    }
}

