/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.relic.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.relic.particles.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketRelicTweak;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public abstract class AbstractRelicActionWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private final PacketRelicTweak.Operation operation;
    private final RelicDescriptionScreen screen;

    public AbstractRelicActionWidget(int x, int y, PacketRelicTweak.Operation operation, RelicDescriptionScreen screen) {
        super(x, y, 14, 14);
        this.operation = operation;
        this.screen = screen;
    }

    @Override
    public abstract boolean isLocked();

    @Override
    public void onPress() {
        if (!this.isLocked()) {
            NetworkHandler.sendToServer(new PacketRelicTweak(this.getScreen().getContainer(), this.getScreen().getSlot(), this.getOperation(), Screen.hasShiftDown()));
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = guiGraphics.pose();
        String actionId = this.getOperation().toString().toLowerCase(Locale.ROOT);
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/relic/" + actionId + "_button_" + (this.isLocked() ? "inactive" : "active") + ".png")), poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY()).end();
        if (this.isHovered()) {
            GUIRenderer.begin(DescriptionTextures.ACTION_BUTTON_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 1).end();
        }
    }

    @Override
    public void onTick() {
        if (this.minecraft.player == null) {
            return;
        }
        RandomSource random = this.minecraft.player.getRandom();
        if (!this.isHovered() || this.minecraft.player.tickCount % 5 != 0) {
            return;
        }
        ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), this.getX() + random.nextInt(this.width), this.getY() + random.nextInt(this.height / 4), 1.0f + random.nextFloat() * 0.25f, 50 + random.nextInt(50)));
    }

    public List<MutableComponent> buildDescription() {
        return new ArrayList<MutableComponent>();
    }

    @Generated
    public PacketRelicTweak.Operation getOperation() {
        return this.operation;
    }

    @Generated
    public RelicDescriptionScreen getScreen() {
        return this.screen;
    }
}

