/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.octostudios.octolib.util.OctoColor;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.particle.PixelUIParticle;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.joml.Vector2f;

public class RelicExperienceWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private static final int FILLER_WIDTH = 125;
    private final DescriptionScreen screen;

    public RelicExperienceWidget(int x, int y, DescriptionScreen screen) {
        super(x, y, 139, 15);
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = this.screen.getStack().getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float color = (float)((double)1.025f + Math.sin((float)player.tickCount * 0.5f) * (double)0.05f);
        GUIRenderer.begin(DescriptionTextures.RELIC_EXPERIENCE_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY() - 10).end();
        RenderSystem.enableBlend();
        GUIRenderer.begin(DescriptionTextures.RELIC_EXPERIENCE_FILLER, poseStack).patternSize(this.calculateFillerWidth(relic), 11).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 3, this.getY() + 2).color(color, color, color, 1.0f).texSize(125, 11).end();
        RenderSystem.disableBlend();
        if (this.isHovered()) {
            GUIRenderer.begin(DescriptionTextures.RELIC_EXPERIENCE_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 6).end();
        }
        poseStack.scale(0.5f, 0.5f, 0.5f);
        MutableComponent percentage = Component.literal((String)(relic.isRelicMaxLevel((LivingEntity)this.minecraft.player, this.screen.getStack()) ? "MAX" : MathUtils.round(this.calculateFillerPercentage(relic), 1) + "%")).withStyle(ChatFormatting.BOLD);
        guiGraphics.drawString(this.minecraft.font, (Component)percentage, (this.getX() + 67) * 2 - this.minecraft.font.width((FormattedText)percentage) / 2, (this.getY() + 6) * 2, 7548704, false);
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        IRelicItem relic;
        LocalPlayer player;
        block6: {
            block5: {
                player = this.minecraft.player;
                Item item = this.screen.getStack().getItem();
                if (!(item instanceof IRelicItem)) break block5;
                relic = (IRelicItem)item;
                if (player != null) break block6;
            }
            return;
        }
        RandomSource random = player.getRandom();
        int fillerWidth = this.calculateFillerWidth(relic);
        if (player.tickCount % 5 == 0) {
            for (float i = 0.0f; i < (float)fillerWidth / 30.0f; i += 1.0f) {
                PixelUIParticle particle = new PixelUIParticle(0.4f, random.nextInt(20, 40), this.getX() + 5 + random.nextInt(fillerWidth), this.getY() + random.nextInt(2), UIParticle.Layer.SCREEN, 10.0f);
                float size = random.nextFloat() * 0.5f + 0.75f;
                particle.setColors(new OctoColor[]{new OctoColor(random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 0.25f, 1.0f, 1.0f), OctoColor.WHITE, new OctoColor(1.0f, random.nextFloat() * 0.25f, random.nextFloat() * 0.5f + 0.25f, 0.0f)});
                particle.setDirection(MathUtils.randomFloat(random) * 0.75f, random.nextFloat() * -0.5f);
                particle.setRollVelocity(MathUtils.randomFloat(random) * 15.0f);
                particle.getTransform().setSize(new Vector2f(size, size));
                particle.setGravityDirection(0.0f, -1.0f);
                particle.setScreen(this.screen);
                particle.setFriction(0.025f);
                particle.setGravity(0.02f);
                particle.instantiate();
            }
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Item item = this.screen.getStack().getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        int level = relic.getRelicLevel((LivingEntity)this.minecraft.player, this.screen.getStack());
        String experience = String.valueOf(MathUtils.round(relic.getRelicExperience((LivingEntity)this.minecraft.player, this.screen.getStack()), 1));
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.literal((String)"").append((Component)Component.translatable((String)"relics.description.researching.relic.experience.title").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + (String)(relic.isRelicMaxLevel((LivingEntity)this.minecraft.player, this.screen.getStack()) ? "MAX" : (experience.endsWith(".0") ? experience.replace(".0", "") : experience) + "/" + relic.getTotalRelicExperienceBetweenLevels((LivingEntity)this.minecraft.player, this.screen.getStack(), level, level + 1))), Component.literal((String)" ")});
        if (Screen.hasShiftDown()) {
            entries.add(Component.translatable((String)"relics.description.researching.relic.experience.extra_info").withStyle(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.translatable((String)"relics.description.researching.general.extra_info"));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 7548704, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }

    private float calculateFillerPercentage(IRelicItem relic) {
        int level = relic.getRelicLevel((LivingEntity)this.minecraft.player, this.screen.getStack());
        return (float)(relic.getRelicExperience((LivingEntity)this.minecraft.player, this.screen.getStack()) / (relic.getTotalRelicExperienceBetweenLevels((LivingEntity)this.minecraft.player, this.screen.getStack(), level, level + 1) / 100.0));
    }

    private int calculateFillerWidth(IRelicItem relic) {
        return relic.isRelicMaxLevel((LivingEntity)this.minecraft.player, this.screen.getStack()) ? 125 : (int)Math.ceil(this.calculateFillerPercentage(relic) / 100.0f * 125.0f);
    }
}

