/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic.widgets;

import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.RelicMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.client.screen.description.base.DescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.SimpleDescriptionContainerWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class RelicStatisticContainerWidget
extends SimpleDescriptionContainerWidget {
    public RelicStatisticContainerWidget(DescriptionScreen screen) {
        super(screen);
    }

    @Override
    public List<FormattedCharSequence> getContent() {
        ArrayList<FormattedCharSequence> sequences = new ArrayList<FormattedCharSequence>();
        ItemStack stack = this.getScreen().getStack();
        IRelicItem relic = (IRelicItem)stack.getItem();
        LocalPlayer player = this.minecraft.player;
        Font font = this.minecraft.font;
        int maxWidth = 320;
        String dot = ".";
        int dotWidth = Math.max(1, font.width(dot));
        for (RelicMetricTemplate metric : relic.getRelicStatisticTemplate((LivingEntity)player, stack).getMetrics().values()) {
            VisibilityState state = metric.getVisibilityState().apply((LivingEntity)player, stack);
            if (state == VisibilityState.HIDDEN) continue;
            MutableComponent prefix = Component.literal((String)"\u25cf ").append(metric.getComponent().apply((LivingEntity)player, stack)).append((Component)Component.literal((String)" "));
            if (state == VisibilityState.OBFUSCATED) {
                prefix = ScreenUtils.randomizeAllCharacters(prefix, this.hashCode()).withStyle(Style.EMPTY.withFont(ScreenUtils.ILLAGER_ALT_FONT).withColor(DescriptionUtils.NEGATIVE_COLOR(true)));
            }
            MutableComponent suffix = Component.literal((String)" ").append((Component)Component.literal((String)metric.getFormatValue().apply(relic.getRelicMetricComponent((LivingEntity)player, stack, metric.getId()).getValue())).withStyle(ChatFormatting.BOLD));
            int suffixWidth = font.width((FormattedText)suffix);
            int limit = Math.max(0, maxWidth - suffixWidth);
            List lines = font.split((FormattedText)prefix, limit);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
                if (i < lines.size() - 1) {
                    sequences.add(line);
                    continue;
                }
                int avail = Math.max(0, maxWidth - font.width(line) - suffixWidth);
                int dotsCount = Math.max(0, avail / dotWidth);
                FormattedCharSequence dots = dotsCount > 0 ? FormattedCharSequence.forward((String)dot.repeat(dotsCount), (Style)Style.EMPTY) : FormattedCharSequence.EMPTY;
                FormattedCharSequence seq = FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{line, dots, suffix.getVisualOrderText()});
                while (font.width(seq) > maxWidth && dotsCount > 0) {
                    dots = --dotsCount > 0 ? FormattedCharSequence.forward((String)dot.repeat(dotsCount), (Style)Style.EMPTY) : FormattedCharSequence.EMPTY;
                    seq = FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{line, dots, suffix.getVisualOrderText()});
                }
                sequences.add(seq);
            }
        }
        return sequences;
    }
}

