/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.config.data;

import it.hurts.octostudios.octolib.module.config.annotation.Prop;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.api.scaling_models.ScalingModel;
import it.hurts.sskirillss.relics.init.RelicsRegistries;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;

public class StatConfigData {
    @Prop(comment="Minimum base value of the stat. A random value within this range is assigned when the relic is first created")
    private double minInitialValue;
    @Prop(comment="Maximum base value of the stat. A random value within this range is assigned when the relic is first created")
    private double maxInitialValue;
    @Prop(comment="Minimum threshold value for the stat, representing hard limits that cannot be surpassed through ability level upgrades or other methods")
    private double minThresholdValue;
    @Prop(comment="Maximum threshold value for the stat, representing hard limits that cannot be surpassed through ability level upgrades or other methods")
    private double maxThresholdValue;
    @Prop(comment="Type of mathematical operation used to calculate the stat's value based on the ability level.")
    private String upgradeOperation;
    @Prop(comment="Modifier applied to the base value of the stat, depending on the [upgradeOperation] parameter.")
    private double upgradeModifier;

    public StatTemplate toData(IRelicItem relic, String ability, String stat) {
        return relic.getDefaultStatTemplate(ability, stat).toBuilder().initialValue(this.minInitialValue, this.maxInitialValue).thresholdValue(this.minThresholdValue, this.maxThresholdValue).upgradeModifier((ScalingModel)RelicsRegistries.SCALING_MODEL_REGISTRY.get(ResourceLocation.parse((String)this.upgradeOperation)), this.upgradeModifier).build();
    }

    @Generated
    public double getMinInitialValue() {
        return this.minInitialValue;
    }

    @Generated
    public double getMaxInitialValue() {
        return this.maxInitialValue;
    }

    @Generated
    public double getMinThresholdValue() {
        return this.minThresholdValue;
    }

    @Generated
    public double getMaxThresholdValue() {
        return this.maxThresholdValue;
    }

    @Generated
    public String getUpgradeOperation() {
        return this.upgradeOperation;
    }

    @Generated
    public double getUpgradeModifier() {
        return this.upgradeModifier;
    }

    @Generated
    public void setMinInitialValue(double minInitialValue) {
        this.minInitialValue = minInitialValue;
    }

    @Generated
    public void setMaxInitialValue(double maxInitialValue) {
        this.maxInitialValue = maxInitialValue;
    }

    @Generated
    public void setMinThresholdValue(double minThresholdValue) {
        this.minThresholdValue = minThresholdValue;
    }

    @Generated
    public void setMaxThresholdValue(double maxThresholdValue) {
        this.maxThresholdValue = maxThresholdValue;
    }

    @Generated
    public void setUpgradeOperation(String upgradeOperation) {
        this.upgradeOperation = upgradeOperation;
    }

    @Generated
    public void setUpgradeModifier(double upgradeModifier) {
        this.upgradeModifier = upgradeModifier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatConfigData)) {
            return false;
        }
        StatConfigData other = (StatConfigData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMinInitialValue(), other.getMinInitialValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxInitialValue(), other.getMaxInitialValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinThresholdValue(), other.getMinThresholdValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxThresholdValue(), other.getMaxThresholdValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getUpgradeModifier(), other.getUpgradeModifier()) != 0) {
            return false;
        }
        String this$upgradeOperation = this.getUpgradeOperation();
        String other$upgradeOperation = other.getUpgradeOperation();
        return !(this$upgradeOperation == null ? other$upgradeOperation != null : !this$upgradeOperation.equals(other$upgradeOperation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StatConfigData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minInitialValue = Double.doubleToLongBits(this.getMinInitialValue());
        result = result * 59 + (int)($minInitialValue >>> 32 ^ $minInitialValue);
        long $maxInitialValue = Double.doubleToLongBits(this.getMaxInitialValue());
        result = result * 59 + (int)($maxInitialValue >>> 32 ^ $maxInitialValue);
        long $minThresholdValue = Double.doubleToLongBits(this.getMinThresholdValue());
        result = result * 59 + (int)($minThresholdValue >>> 32 ^ $minThresholdValue);
        long $maxThresholdValue = Double.doubleToLongBits(this.getMaxThresholdValue());
        result = result * 59 + (int)($maxThresholdValue >>> 32 ^ $maxThresholdValue);
        long $upgradeModifier = Double.doubleToLongBits(this.getUpgradeModifier());
        result = result * 59 + (int)($upgradeModifier >>> 32 ^ $upgradeModifier);
        String $upgradeOperation = this.getUpgradeOperation();
        result = result * 59 + ($upgradeOperation == null ? 43 : $upgradeOperation.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StatConfigData(minInitialValue=" + this.getMinInitialValue() + ", maxInitialValue=" + this.getMaxInitialValue() + ", minThresholdValue=" + this.getMinThresholdValue() + ", maxThresholdValue=" + this.getMaxThresholdValue() + ", upgradeOperation=" + this.getUpgradeOperation() + ", upgradeModifier=" + this.getUpgradeModifier() + ")";
    }

    @Generated
    public StatConfigData() {
    }

    @Generated
    public StatConfigData(double minInitialValue, double maxInitialValue, double minThresholdValue, double maxThresholdValue, String upgradeOperation, double upgradeModifier) {
        this.minInitialValue = minInitialValue;
        this.maxInitialValue = maxInitialValue;
        this.minThresholdValue = minThresholdValue;
        this.maxThresholdValue = maxThresholdValue;
        this.upgradeOperation = upgradeOperation;
        this.upgradeModifier = upgradeModifier;
    }
}

