/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.effects;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.models.effects.StunStarModel;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

public class StunEffect
extends MobEffect {
    public StunEffect() {
        super(MobEffectCategory.HARMFUL, 14333990);
    }

    @EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onMouseInput(InputEvent.InteractionKeyMappingTriggered event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && player.hasEffect(RelicsMobEffects.STUN)) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockHighlight(RenderHighlightEvent.Block event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && player.hasEffect(RelicsMobEffects.STUN)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onEntityRender(RenderLivingEvent.Pre<?, ?> event) {
            LivingEntity entity = event.getEntity();
            MobEffectInstance effect = entity.getEffect(RelicsMobEffects.STUN);
            if (effect == null || entity.isDeadOrDying()) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate(0.0f, entity.getBbHeight() + 0.25f, 0.0f);
            poseStack.scale(0.25f, 0.25f, 0.25f);
            int stars = Math.round(entity.getBbWidth() * 10.0f);
            float ticks = (float)entity.tickCount + event.getPartialTick();
            float radius = 1.0f + (float)stars * 0.15f;
            for (int i = 0; i < stars; ++i) {
                poseStack.pushPose();
                double angle = (double)(ticks / 20.0f) + Math.PI * 2 / (double)stars * (double)i;
                float x = Mth.cos((float)((float)angle)) * radius;
                float z = Mth.sin((float)((float)angle)) * radius;
                float y = Mth.sin((float)(ticks * 0.15f + (float)i * 0.75f)) * 0.25f;
                poseStack.translate(x, y, z);
                float rotDeg = (float)Math.toDegrees(angle) + 90.0f;
                poseStack.mulPose(Axis.YP.rotationDegrees(rotDeg));
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                new StunStarModel().renderToBuffer(poseStack, event.getMultiBufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/mob_effect/model/stun_star.png"))), 0xF000F0, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
            poseStack.popPose();
        }

        @SubscribeEvent
        public static void onComputeFOV(ComputeFovModifierEvent event) {
            float threshold;
            Player player = event.getPlayer();
            MobEffectInstance effect = player.getEffect(RelicsMobEffects.STUN);
            if (effect == null) {
                return;
            }
            int duration = effect.getDuration();
            float factor = (float)duration > (threshold = 80.0f) ? 0.5f : (1.0f - (float)duration / threshold) * 0.5f + 0.5f;
            event.setNewFovModifier(Math.clamp(factor, 0.5f, 1.0f));
        }
    }
}

