/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.effects;

import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class TremorEffect
extends MobEffect {
    public TremorEffect() {
        super(MobEffectCategory.HARMFUL, 6829738);
    }

    @EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onMouseInput(InputEvent.InteractionKeyMappingTriggered event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && player.hasEffect(RelicsMobEffects.TREMOR)) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onRenderHand(RenderHandEvent event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && player.hasEffect(RelicsMobEffects.TREMOR)) {
                PoseStack poseStack = event.getPoseStack();
                float age = (float)player.tickCount + event.getPartialTick();
                float shakeX = (float)Math.sin(age * 20.0f) * 0.01f;
                float shakeY = (float)Math.cos(age * 20.0f) * 0.01f;
                poseStack.translate(shakeX, shakeY, 0.0f);
            }
        }
    }

    @EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingAttack(EntityInvulnerabilityCheckEvent event) {
            LivingEntity entity;
            if (event.getOriginalInvulnerability()) {
                return;
            }
            Entity entity2 = event.getSource().getDirectEntity();
            if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).hasEffect(RelicsMobEffects.TREMOR)) {
                event.setInvulnerable(true);
            }
        }

        @SubscribeEvent
        public static void onItemUse(LivingEntityUseItemEvent.Start event) {
            if (event.getEntity().hasEffect(RelicsMobEffects.TREMOR)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockBreakSpeed(PlayerEvent.BreakSpeed event) {
            if (event.getEntity().hasEffect(RelicsMobEffects.TREMOR)) {
                event.setNewSpeed(0.0f);
            }
        }

        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            if (event.getPlayer().hasEffect(RelicsMobEffects.TREMOR)) {
                event.setCanceled(true);
            }
        }
    }
}

