/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import it.hurts.sskirillss.relics.items.relics.necklace.JellyfishNecklaceItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.sync.S2CSyncEntityTargetPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ElectricSparkEntity
extends ThrowableProjectile
implements ITargetableEntity {
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.defineId(ElectricSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(ElectricSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(ElectricSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DAMAGE_MODIFIER = SynchedEntityData.defineId(ElectricSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> FLAWLESS = SynchedEntityData.defineId(ElectricSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemStack stack = ItemStack.EMPTY;
    private Set<String> bouncedTargets = new HashSet<String>();
    private List<String> blacklistedTargets = new ArrayList<String>();
    @Nullable
    private LivingEntity currentTarget = null;
    @Nullable
    private LivingEntity lastTarget = null;

    public ElectricSparkEntity(EntityType<? extends ElectricSparkEntity> type, Level level) {
        super(type, level);
    }

    public void setBounces(int bounces) {
        this.getEntityData().set(BOUNCES, (Object)bounces);
    }

    public int getBounces() {
        return (Integer)this.getEntityData().get(BOUNCES);
    }

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public void setDistance(float distance) {
        this.getEntityData().set(DISTANCE, (Object)Float.valueOf(distance));
    }

    public float getDistance() {
        return ((Float)this.getEntityData().get(DISTANCE)).floatValue();
    }

    public void setDamageModifier(float damage) {
        this.getEntityData().set(DAMAGE_MODIFIER, (Object)Float.valueOf(damage));
    }

    public float getDamageModifier() {
        return ((Float)this.getEntityData().get(DAMAGE_MODIFIER)).floatValue();
    }

    public void setFlawless(boolean flawless) {
        this.getEntityData().set(FLAWLESS, (Object)flawless);
    }

    public boolean isFlawless() {
        return (Boolean)this.getEntityData().get(FLAWLESS);
    }

    public List<LivingEntity> locateNearestTargets() {
        return EntityUtils.gatherPotentialTargets((Entity)this, LivingEntity.class, this.getDistance()).filter(entity -> {
            Player player;
            Entity patt0$temp;
            return !(this.lastTarget != null && this.lastTarget.getStringUUID().equals(entity.getStringUUID()) || (patt0$temp = this.getOwner()) instanceof Player && EntityUtils.isAlliedTo((Entity)(player = (Player)patt0$temp), (Entity)entity) || this.blacklistedTargets.contains(entity.getStringUUID()) || this.bouncedTargets.contains(entity.getStringUUID()));
        }).collect(Collectors.toList());
    }

    public void tick() {
        super.tick();
        Level level = this.getCommandSenderWorld();
        LivingEntity currentTarget = this.getTarget();
        float distance = this.getDistance();
        if (currentTarget != null) {
            if (this.position().distanceTo(currentTarget.position()) >= (double)distance || currentTarget.isDeadOrDying()) {
                currentTarget = null;
            }
        } else if (!level.isClientSide()) {
            LivingEntity selectedTarget = null;
            List<LivingEntity> nearbyTargets = this.locateNearestTargets();
            if (nearbyTargets.isEmpty()) {
                this.bouncedTargets.clear();
                nearbyTargets = this.locateNearestTargets();
            }
            if (!nearbyTargets.isEmpty()) {
                double totalWeight = 0.0;
                ArrayList<Double> weightList = new ArrayList<Double>();
                for (LivingEntity targetCandidate : nearbyTargets) {
                    double distanceToCandidate = this.position().distanceTo(targetCandidate.position());
                    double candidateWeight = (double)distance - distanceToCandidate;
                    weightList.add(candidateWeight);
                    totalWeight += candidateWeight;
                }
                double randomPoint = this.random.nextDouble() * totalWeight;
                double cumulativeWeight = 0.0;
                for (int i = 0; i < nearbyTargets.size(); ++i) {
                    if (!(randomPoint <= (cumulativeWeight += ((Double)weightList.get(i)).doubleValue()))) continue;
                    selectedTarget = nearbyTargets.get(i);
                    break;
                }
            }
            if (selectedTarget != null) {
                this.setTarget(selectedTarget);
                currentTarget = selectedTarget;
            }
        }
        if (currentTarget == null || currentTarget.isDeadOrDying() || this.tickCount >= 250 || this.getBounces() <= 0) {
            if (!level.isClientSide()) {
                this.discard();
            }
            return;
        }
        if (this.getEyePosition().distanceTo(currentTarget.getEyePosition()) <= 1.5) {
            currentTarget.invulnerableTime = 0;
            float damage = this.getDamage();
            Entity owner = this.getOwner();
            if (currentTarget.hurt(level.damageSources().thrown((Entity)this, owner), damage + (currentTarget.isInLiquid() || currentTarget.isInRain() ? damage * this.getDamageModifier() : 0.0f))) {
                Item item;
                this.bouncedTargets.add(currentTarget.getStringUUID());
                this.lastTarget = currentTarget;
                this.setTarget(null);
                this.setBounces(this.getBounces() - 1);
                if (!level.isClientSide() && (item = this.stack.getItem()) instanceof JellyfishNecklaceItem) {
                    JellyfishNecklaceItem relic = (JellyfishNecklaceItem)item;
                    if (owner instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)owner;
                        relic.addAbilityMetricValue(entity, this.stack, "shock", "arcs_bounces", 1.0);
                        relic.addAbilityMetricValue(entity, this.stack, "shock", "arcs_damage", damage);
                        relic.addRelicExperience(entity, this.stack, "shock", "arcs_bouncing", 1.0);
                    }
                }
            } else {
                this.blacklistedTargets.add(currentTarget.getStringUUID());
                this.setTarget(null);
            }
        } else {
            this.setDeltaMovement(currentTarget.getEyePosition().subtract(this.getEyePosition()).normalize().scale(1.75));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BOUNCES, (Object)0);
        builder.define(DAMAGE, (Object)Float.valueOf(1.0f));
        builder.define(DISTANCE, (Object)Float.valueOf(1.0f));
        builder.define(DAMAGE_MODIFIER, (Object)Float.valueOf(0.0f));
        builder.define(FLAWLESS, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("bounces", this.getBounces());
        tag.putFloat("damage", this.getDamage());
        tag.putFloat("distance", this.getDistance());
        tag.putFloat("damage_modifier", this.getDamageModifier());
        tag.putBoolean("flawless", this.isFlawless());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBounces(tag.getInt("bounces"));
        this.setDamage(tag.getFloat("damage"));
        this.setDistance(tag.getFloat("distance"));
        this.setDamageModifier(tag.getFloat("damage_modifier"));
        this.setFlawless(tag.getBoolean("flawless"));
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.currentTarget;
    }

    @Override
    public void setTarget(LivingEntity target) {
        if (target != null && !target.level().isClientSide()) {
            NetworkHandler.sendToClientsTrackingEntity(new S2CSyncEntityTargetPacket(this.getId(), target.getId()), (Entity)this);
        }
        this.currentTarget = target;
    }

    @Generated
    public ItemStack getStack() {
        return this.stack;
    }

    @Generated
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailProvider
    extends EntityTrailProvider<ElectricSparkEntity> {
        public TrailProvider(ElectricSparkEntity entity) {
            super((Entity)entity);
        }

        public Vec3 getTrailPosition(float partialTicks) {
            return ((ElectricSparkEntity)this.entity).getPosition(partialTicks).add(((ElectricSparkEntity)this.entity).getDeltaMovement().scale(-1.0));
        }

        public int getTrailUpdateFrequency() {
            return 1;
        }

        public boolean isTrailAlive() {
            return ((ElectricSparkEntity)this.entity).isAlive();
        }

        public boolean isTrailGrowing() {
            return ((ElectricSparkEntity)this.entity).getKnownMovement().length() >= (double)0.1f;
        }

        public int getTrailMaxLength() {
            return 3;
        }

        public int getTrailFadeInColor() {
            return ((ElectricSparkEntity)this.entity).isFlawless() ? -256 : -16711681;
        }

        public int getTrailFadeOutColor() {
            return ((ElectricSparkEntity)this.entity).isFlawless() ? 0xFF0000 : -2147483393;
        }

        public double getTrailScale() {
            return 0.1f;
        }
    }
}

