/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.items.relics.back.LeafyMantleItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.sync.S2CSyncEntityTargetPacket;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class LeavesBlockEntity
extends ThrowableProjectile
implements ITargetableEntity {
    private static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.defineId(LeavesBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(LeavesBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> PARALYSIS = SynchedEntityData.defineId(LeavesBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> FLAWLESS = SynchedEntityData.defineId(LeavesBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemStack stack = ItemStack.EMPTY;
    private LivingEntity target;
    private List<String> impactedEntities = new ArrayList<String>();

    public BlockState getBlockState() {
        return (BlockState)this.getEntityData().get(BLOCK_STATE);
    }

    public void setBlockState(BlockState state) {
        this.getEntityData().set(BLOCK_STATE, (Object)state);
    }

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public void setParalysis(float paralysis) {
        this.getEntityData().set(PARALYSIS, (Object)Float.valueOf(paralysis));
    }

    public float getParalysis() {
        return ((Float)this.getEntityData().get(PARALYSIS)).floatValue();
    }

    public void setFlawless(boolean flawless) {
        this.getEntityData().set(FLAWLESS, (Object)flawless);
    }

    public boolean isFlawless() {
        return (Boolean)this.getEntityData().get(FLAWLESS);
    }

    public LeavesBlockEntity(EntityType<? extends LeavesBlockEntity> type, Level worldIn) {
        super(type, worldIn);
        this.noPhysics = true;
    }

    public void tick() {
        Vec3 motion = this.getDeltaMovement();
        super.tick();
        Level level = this.getCommandSenderWorld();
        RandomSource random = level.getRandom();
        for (int i = 0; i < 3; ++i) {
            level.addParticle(ParticleUtils.constructSimpleSpark(this.isFlawless() ? new Color(200 + random.nextInt(50), 150 + random.nextInt(50), 0) : new Color(random.nextInt(75), 150 + random.nextInt(100), random.nextInt(25)), 0.1f + random.nextFloat() * 0.15f, 25 + random.nextInt(10), 0.9f), this.getX() + (double)(MathUtils.randomFloat(random) * 0.25f), this.getY() + (double)(MathUtils.randomFloat(random) * 0.25f) + (double)(this.getBbHeight() / 2.0f), this.getZ() + (double)(MathUtils.randomFloat(random) * 0.25f), (double)(MathUtils.randomFloat(random) * 0.01f), (double)(MathUtils.randomFloat(random) * 0.01f), (double)(MathUtils.randomFloat(random) * 0.01f));
        }
        if (this.target == null || this.target.isDeadOrDying() || this.tickCount >= 200) {
            if (!level.isClientSide()) {
                this.discard();
            }
            return;
        }
        Vec3 targetPos = this.target.position().add(0.0, (double)(this.target.getBbHeight() / 2.0f), 0.0);
        if (this.position().distanceTo(targetPos) > 1.0) {
            float factor = Math.clamp((float)this.tickCount * 0.035f, 0.0f, 1.0f);
            this.setDeltaMovement(motion.lerp(targetPos.subtract(this.position()).normalize().scale((double)factor), (double)factor));
        } else {
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity owner;
        LivingEntity entity;
        block9: {
            block8: {
                Entity entity2 = result.getEntity();
                if (!(entity2 instanceof LivingEntity) || this.impactedEntities.contains((entity = (LivingEntity)entity2).getStringUUID()) || !((entity2 = this.getOwner()) instanceof LivingEntity)) break block8;
                owner = (LivingEntity)entity2;
                if (!entity.getStringUUID().equals(owner.getStringUUID())) break block9;
            }
            return;
        }
        Level level = this.level();
        entity.invulnerableTime = 0;
        if (entity.hurt(level.damageSources().thrown((Entity)owner, (Entity)this), this.getDamage())) {
            Item item;
            float paralysis = this.getParalysis();
            if (paralysis > 0.0f) {
                entity.addEffect(new MobEffectInstance(RelicsMobEffects.PARALYSIS, (int)(paralysis * 20.0f), 0, false, false));
            }
            if ((item = this.stack.getItem()) instanceof LeafyMantleItem) {
                LeafyMantleItem relic = (LeafyMantleItem)item;
                relic.addAbilityMetricValue(entity, this.stack, "revival", "damage_dealt", this.getDamage());
                if (!level.isClientSide()) {
                    relic.addRelicExperience(entity, this.stack, "revival", "leaves_impact", 1.0);
                }
                if (paralysis > 0.0f) {
                    relic.addAbilityMetricValue(entity, this.stack, "revival", "paralysis_duration", paralysis);
                }
            }
        }
        this.impactedEntities.add(entity.getStringUUID());
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide()) {
            return false;
        }
        Entity owner = this.getOwner();
        Entity attacker = source.getEntity();
        if (owner != null && attacker != null && owner.getStringUUID().equals(attacker.getStringUUID())) {
            return false;
        }
        this.playSound(SoundEvents.SHULKER_BULLET_HURT, 1.0f, 1.0f);
        this.discard();
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BLOCK_STATE, (Object)Blocks.OAK_LEAVES.defaultBlockState());
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(PARALYSIS, (Object)Float.valueOf(0.0f));
        builder.define(FLAWLESS, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("block_state", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlockState()));
        tag.putFloat("damage", this.getDamage());
        tag.putFloat("paralysis", this.getParalysis());
        tag.putBoolean("flawless", this.isFlawless());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.getCommandSenderWorld().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("block_state")));
        this.setDamage(tag.getFloat("damage"));
        this.setParalysis(tag.getFloat("paralysis"));
        this.setFlawless(tag.getBoolean("flawless"));
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.target = target;
        if (!this.level().isClientSide() && target != null) {
            NetworkHandler.sendToClientsTrackingEntity(new S2CSyncEntityTargetPacket(this.getId(), target.getId()), (Entity)this);
        }
    }

    @Generated
    public ItemStack getStack() {
        return this.stack;
    }

    @Generated
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailProvider
    extends EntityTrailProvider<LeavesBlockEntity> {
        public TrailProvider(LeavesBlockEntity entity) {
            super((Entity)entity);
        }

        public Vec3 getTrailPosition(float partialTicks) {
            return ((LeavesBlockEntity)this.entity).getPosition(partialTicks).add(0.0, (double)0.35f, 0.0);
        }

        public int getTrailUpdateFrequency() {
            return 1;
        }

        public boolean isTrailAlive() {
            return ((LeavesBlockEntity)this.entity).isAlive();
        }

        public boolean isTrailGrowing() {
            return ((LeavesBlockEntity)this.entity).tickCount > 1;
        }

        public int getTrailMaxLength() {
            return 10;
        }

        public int getTrailFadeInColor() {
            return ((LeavesBlockEntity)this.entity).isFlawless() ? -256 : -16711936;
        }

        public int getTrailFadeOutColor() {
            return ((LeavesBlockEntity)this.entity).isFlawless() ? 0xFF0000 : -2130706688;
        }

        public double getTrailScale() {
            return 0.15f;
        }
    }
}

