/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.sync.S2CSyncEntityTargetPacket;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class LifeEssenceEntity
extends ThrowableProjectile
implements ITargetableEntity {
    private static final EntityDataAccessor<Float> HEAL = SynchedEntityData.defineId(LifeEssenceEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private LivingEntity target;

    public void setHeal(float heal) {
        this.getEntityData().set(HEAL, (Object)Float.valueOf(heal));
    }

    public float getHeal() {
        return ((Float)this.getEntityData().get(HEAL)).floatValue();
    }

    public LifeEssenceEntity(EntityType<? extends LifeEssenceEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        super.tick();
        Level level = this.getCommandSenderWorld();
        level.addParticle(ParticleUtils.constructSimpleSpark(new Color(200 + this.random.nextInt(50), 150 + this.random.nextInt(50), this.random.nextInt(50)), 0.05f, 10, 0.9f), this.xOld, this.yOld, this.zOld, -this.getDeltaMovement().x * (double)0.1f * (double)this.random.nextFloat(), -this.getDeltaMovement().y * (double)0.1f * (double)this.random.nextFloat(), -this.getDeltaMovement().z * (double)0.1f * (double)this.random.nextFloat());
        if (this.target == null || this.target.isDeadOrDying() || this.tickCount >= 250) {
            if (!level.isClientSide()) {
                this.discard();
            }
            return;
        }
        if (this.position().distanceTo(this.target.getEyePosition()) > 1.0) {
            Vec3 direction = this.target.getEyePosition().subtract(this.position()).normalize();
            Vec3 motion = this.getDeltaMovement();
            int window = 5;
            if (this.tickCount > window) {
                float factor = Math.clamp((float)(this.tickCount - window) * 0.1f, 0.0f, 1.0f);
                this.setDeltaMovement(motion.x + (direction.x * (double)factor - motion.x) * (double)factor, motion.y + (direction.y * (double)factor - motion.y) * (double)factor, motion.z + (direction.z * (double)factor - motion.z) * (double)factor);
            }
        } else {
            this.target.heal(this.getHeal());
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(HEAL, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("heal", this.getHeal());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setHeal(tag.getFloat("heal"));
    }

    public boolean isNoGravity() {
        return false;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.target = target;
        if (!this.level().isClientSide() && target != null) {
            NetworkHandler.sendToClientsTrackingEntity(new S2CSyncEntityTargetPacket(this.getId(), target.getId()), (Entity)this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailProvider
    extends EntityTrailProvider<LifeEssenceEntity> {
        public TrailProvider(LifeEssenceEntity entity) {
            super((Entity)entity);
        }

        public Vec3 getTrailPosition(float partialTicks) {
            return ((LifeEssenceEntity)this.entity).getPosition(partialTicks).add(((LifeEssenceEntity)this.entity).getDeltaMovement().scale(-1.0));
        }

        public int getTrailUpdateFrequency() {
            return 1;
        }

        public boolean isTrailAlive() {
            return ((LifeEssenceEntity)this.entity).isAlive();
        }

        public boolean isTrailGrowing() {
            return ((LifeEssenceEntity)this.entity).tickCount > 2;
        }

        public int getTrailMaxLength() {
            return 5;
        }

        public int getTrailFadeInColor() {
            return -256;
        }

        public int getTrailFadeOutColor() {
            return -2130771968;
        }

        public double getTrailScale() {
            return 0.025f;
        }
    }
}

