/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.entities.ShockwaveBlockEntity;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.items.relics.back.MidnightMantleItem;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MidnightMantleShockwaveBlockEntity
extends ShockwaveBlockEntity {
    public MidnightMantleShockwaveBlockEntity(EntityType<? extends ShockwaveBlockEntity> pEntityType, Level level) {
        super(pEntityType, level);
    }

    @Override
    public void processTargets() {
        Level level = this.level();
        Entity owner = this.getOwner();
        for (Entity entity2 : level.getEntitiesOfClass(Entity.class, this.getBoundingBox(), entity -> !(entity instanceof ShockwaveBlockEntity) && (owner == null || !owner.getStringUUID().equals(entity.getStringUUID())))) {
            ItemStack stack;
            Item item;
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            float damage = this.getDamage();
            if (!livingEntity.hurt(level.damageSources().explosion(owner, (Entity)this), damage)) continue;
            int stun = this.getStun();
            if (stun > 0) {
                livingEntity.addEffect(new MobEffectInstance(RelicsMobEffects.STUN, stun, 0, false, false));
            }
            if (!((item = (stack = this.getStack()).getItem()) instanceof MidnightMantleItem)) continue;
            MidnightMantleItem relic = (MidnightMantleItem)item;
            if (!(owner instanceof LivingEntity)) continue;
            LivingEntity livingOwner = (LivingEntity)owner;
            relic.addAbilityMetricValue(livingOwner, stack, "starfall", "shockwave_targets", 1.0);
            relic.addRelicExperience(livingOwner, stack, "starfall", "shockwave_hit", 1.0);
            relic.addAbilityMetricValue(livingOwner, stack, "starfall", "shockwave_damage", damage);
            if (stun <= 0) continue;
            relic.addAbilityMetricValue(livingOwner, stack, "starfall", "shockwave_stun", (float)stun / 20.0f);
        }
    }
}

