/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.octostudios.octolib.module.particle.trail.EntityTrailProvider;
import it.hurts.sskirillss.relics.items.relics.feet.RollerSkateItem;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RollerSparkEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(RollerSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> IGNITE = SynchedEntityData.defineId(RollerSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> FLAWLESS = SynchedEntityData.defineId(RollerSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemStack stack = ItemStack.EMPTY;
    private boolean bounced = false;

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public void setIgnite(float ignite) {
        this.getEntityData().set(IGNITE, (Object)Float.valueOf(ignite));
    }

    public float getIgnite() {
        return ((Float)this.getEntityData().get(IGNITE)).floatValue();
    }

    public void setFlawless(boolean flawless) {
        this.getEntityData().set(FLAWLESS, (Object)flawless);
    }

    public boolean isFlawless() {
        return (Boolean)this.getEntityData().get(FLAWLESS);
    }

    public RollerSparkEntity(EntityType<? extends RollerSparkEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        Vec3 motion = this.getDeltaMovement();
        super.tick();
        if (this.tickCount > 100 || motion.length() < (double)0.1f) {
            this.discard();
        }
        this.bounced = false;
    }

    protected void onHitBlock(BlockHitResult result) {
        BlockPos pos = result.getBlockPos();
        Level level = this.level();
        if (level.isClientSide() || this.noPhysics || this.bounced || !level.getBlockState(pos).blocksMotion()) {
            return;
        }
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)result.getDirection().getNormal()).normalize();
        double restitution = 0.7;
        Vec3 motion = this.getDeltaMovement();
        Vec3 reflected = motion.subtract(normal.scale(2.0 * motion.dot(normal))).scale(restitution);
        this.setDeltaMovement(reflected);
        this.bounced = true;
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity owner;
        LivingEntity entity;
        block8: {
            block7: {
                Entity entity2 = result.getEntity();
                if (!(entity2 instanceof LivingEntity)) break block7;
                entity = (LivingEntity)entity2;
                entity2 = this.getOwner();
                if (!(entity2 instanceof LivingEntity)) break block7;
                owner = (LivingEntity)entity2;
                if (!entity.getStringUUID().equals(owner.getStringUUID())) break block8;
            }
            return;
        }
        entity.invulnerableTime = 0;
        float damage = this.getDamage();
        if (entity.hurt(this.level().damageSources().thrown((Entity)owner, (Entity)this), this.getDamage())) {
            float ignite = this.getIgnite();
            int toApply = (int)(ignite * 20.0f);
            int current = entity.getRemainingFireTicks();
            int diff = toApply - current;
            if (ignite > 0.0f) {
                entity.setRemainingFireTicks(Math.max(toApply, current));
            }
            this.discard();
            Item item = this.stack.getItem();
            if (item instanceof RollerSkateItem) {
                RollerSkateItem relic = (RollerSkateItem)item;
                relic.addAbilityMetricValue(owner, this.stack, "skating", "damage_dealt", damage);
                relic.addRelicExperience(owner, this.stack, "skating", "spark_hit", 1.0);
                if (diff > 0) {
                    relic.addAbilityMetricValue(owner, this.stack, "skating", "ignite_duration", (float)diff / 20.0f);
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(IGNITE, (Object)Float.valueOf(0.0f));
        builder.define(FLAWLESS, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("damage", this.getDamage());
        tag.putFloat("ignite", this.getIgnite());
        tag.putBoolean("flawless", this.isFlawless());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDamage(tag.getFloat("damage"));
        this.setIgnite(tag.getFloat("ignite"));
        this.setFlawless(tag.getBoolean("flawless"));
    }

    protected double getDefaultGravity() {
        return 0.03;
    }

    @Generated
    public ItemStack getStack() {
        return this.stack;
    }

    @Generated
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrailProvider
    extends EntityTrailProvider<RollerSparkEntity> {
        public TrailProvider(RollerSparkEntity entity) {
            super((Entity)entity);
        }

        public Vec3 getTrailPosition(float partialTicks) {
            return ((RollerSparkEntity)this.entity).getPosition(partialTicks).add(0.0, (double)0.35f, 0.0);
        }

        public int getTrailUpdateFrequency() {
            return 1;
        }

        public boolean isTrailAlive() {
            return ((RollerSparkEntity)this.entity).isAlive();
        }

        public boolean isTrailGrowing() {
            return ((RollerSparkEntity)this.entity).tickCount > 1;
        }

        public int getTrailMaxLength() {
            return 3;
        }

        public int getTrailFadeInColor() {
            return -256;
        }

        public int getTrailFadeOutColor() {
            return ((RollerSparkEntity)this.entity).isFlawless() ? 0xFF0000 : -2130771968;
        }

        public double getTrailScale() {
            return 0.01f;
        }
    }
}

