/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.entities.ShockwaveBlockEntity;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.items.relics.feet.SpringyBootItem;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpringyBootShockwaveBlockEntity
extends ShockwaveBlockEntity {
    public SpringyBootShockwaveBlockEntity(EntityType<? extends ShockwaveBlockEntity> pEntityType, Level level) {
        super(pEntityType, level);
    }

    @Override
    public void processTargets() {
        Level level = this.level();
        Vec3 center = this.getCenter().getCenter();
        Entity owner = this.getOwner();
        for (Entity entity2 : level.getEntitiesOfClass(Entity.class, this.getBoundingBox(), entity -> !(entity instanceof ShockwaveBlockEntity) && (owner == null || !owner.getStringUUID().equals(entity.getStringUUID())))) {
            ItemStack stack;
            Item item;
            Vec3 motion = entity2.position().add(0.0, 1.0, 0.0).subtract(center).normalize().scale((double)this.getKnockback());
            entity2.setDeltaMovement(motion);
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            float damage = this.getDamage();
            if (!livingEntity.hurt(level.damageSources().explosion(owner, (Entity)this), damage)) continue;
            int stun = this.getStun();
            if (stun > 0) {
                livingEntity.addEffect(new MobEffectInstance(RelicsMobEffects.STUN, stun, 0, false, false));
            }
            if (!((item = (stack = this.getStack()).getItem()) instanceof SpringyBootItem)) continue;
            SpringyBootItem relic = (SpringyBootItem)item;
            relic.addAbilityMetricValue(livingEntity, stack, "bounce", "shockwave_targets", 1.0);
            relic.addRelicExperience(livingEntity, stack, "bounce", "shockwave_hit", 1.0);
            relic.addAbilityMetricValue(livingEntity, stack, "bounce", "shockwave_damage", damage);
            if (stun <= 0) continue;
            relic.addAbilityMetricValue(livingEntity, stack, "bounce", "shockwave_stun", (double)stun / 20.0);
        }
    }
}

