/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities.relic.midnight_mantle;

import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.items.relics.back.MidnightMantleItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ConstellationStarEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.defineId(ConstellationStarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> TREMOR = SynchedEntityData.defineId(ConstellationStarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> STUN = SynchedEntityData.defineId(ConstellationStarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CONSTELLATION_RADIUS = SynchedEntityData.defineId(ConstellationStarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> EXPLOSION_RADIUS = SynchedEntityData.defineId(ConstellationStarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(ConstellationStarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<String> CONSTELLATION = SynchedEntityData.defineId(ConstellationStarEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> STUCK = SynchedEntityData.defineId(ConstellationStarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FLAWLESS = SynchedEntityData.defineId(ConstellationStarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemStack stack = ItemStack.EMPTY;

    public void setLifetime(int lifetime) {
        this.getEntityData().set(LIFETIME, (Object)lifetime);
    }

    public int getLifetime() {
        return (Integer)this.getEntityData().get(LIFETIME);
    }

    public void setTremor(float tremor) {
        this.getEntityData().set(TREMOR, (Object)Float.valueOf(tremor));
    }

    public float getTremor() {
        return ((Float)this.getEntityData().get(TREMOR)).floatValue();
    }

    public void setStun(float stun) {
        this.getEntityData().set(STUN, (Object)Float.valueOf(stun));
    }

    public float getStun() {
        return ((Float)this.getEntityData().get(STUN)).floatValue();
    }

    public void setConstellationRadius(float radius) {
        this.getEntityData().set(CONSTELLATION_RADIUS, (Object)Float.valueOf(radius));
    }

    public float getConstellationRadius() {
        return ((Float)this.getEntityData().get(CONSTELLATION_RADIUS)).floatValue();
    }

    public void setExplosionRadius(float radius) {
        this.getEntityData().set(EXPLOSION_RADIUS, (Object)Float.valueOf(radius));
    }

    public float getExplosionRadius() {
        return ((Float)this.getEntityData().get(EXPLOSION_RADIUS)).floatValue();
    }

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public void setRawConstellation(String constellation) {
        this.getEntityData().set(CONSTELLATION, (Object)constellation);
    }

    public void setConstellation(List<UUID> constellation) {
        this.setRawConstellation(constellation.stream().map(UUID::toString).collect(Collectors.joining("+")));
    }

    public void setFlawless(boolean flawless) {
        this.getEntityData().set(FLAWLESS, (Object)flawless);
    }

    public boolean isStuck() {
        return (Boolean)this.getEntityData().get(STUCK);
    }

    public void setStuck(boolean stuck) {
        this.getEntityData().set(STUCK, (Object)stuck);
    }

    public boolean isFlawless() {
        return (Boolean)this.getEntityData().get(FLAWLESS);
    }

    public ConstellationStarEntity(EntityType<? extends ConstellationStarEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        super.tick();
        if (this.isStuck()) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        Level level = this.level();
        if (this.isStuck()) {
            if (!level.isClientSide()) {
                if (!level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox(), entity -> this.getOwner() == null || !this.getOwner().getStringUUID().equals(entity.getStringUUID())).isEmpty()) {
                    this.discard();
                }
                if (this.tickCount % 5 == 0 && this.tickCount >= this.getLifetime() * 20 && this.random.nextInt(20) == 0) {
                    this.discard();
                }
            }
            if (level.isClientSide()) {
                Color color = this.isFlawless() ? new Color(200 + this.random.nextInt(50), 150 + this.random.nextInt(50), 0) : new Color(50 + this.random.nextInt(50), 50 + this.random.nextInt(150), 255);
                ParticleOptions data = ParticleUtils.constructSimpleSpark(color, 0.2f + this.random.nextFloat() * 0.1f, 30 + this.random.nextInt(20), 0.95f);
                level.addParticle(data, this.getX() + (double)(MathUtils.randomFloat(this.random) * this.getBbWidth() / 2.0f), this.getY(), this.getZ() + (double)(MathUtils.randomFloat(this.random) * this.getBbWidth() / 2.0f), 0.0, (double)(0.1f + this.random.nextFloat() * 0.1f), 0.0);
            }
            ConstellationStarEntity origin = this;
            ArrayDeque<ConstellationStarEntity> queue = new ArrayDeque<ConstellationStarEntity>();
            HashSet<ConstellationStarEntity> visited = new HashSet<ConstellationStarEntity>();
            queue.add(origin);
            visited.add(origin);
            while (!queue.isEmpty()) {
                ConstellationStarEntity current = (ConstellationStarEntity)((Object)queue.removeFirst());
                List neighbors = level.getEntitiesOfClass(ConstellationStarEntity.class, current.getBoundingBox().inflate((double)this.getConstellationRadius()));
                for (ConstellationStarEntity star : neighbors) {
                    if (!visited.add(star)) continue;
                    queue.add(star);
                }
            }
            if (visited.size() < 2) {
                return;
            }
            ArrayList sortedIds = new ArrayList(visited);
            int originIndex = sortedIds.indexOf((Object)origin);
            int totalStars = sortedIds.size();
            ConstellationStarEntity[] starEntities = new ConstellationStarEntity[totalStars];
            Vec3[] starCenters = new Vec3[totalStars];
            double[] midYs = new double[totalStars];
            for (int i = 0; i < totalStars; ++i) {
                Vec3 c;
                ConstellationStarEntity e2;
                starEntities[i] = e2 = (ConstellationStarEntity)((Object)sortedIds.get(i));
                if (e2 == null) continue;
                starCenters[i] = c = e2.getBoundingBox().getCenter();
                midYs[i] = c.y;
            }
            ArrayList<int[]> edges = new ArrayList<int[]>();
            boolean[][] exists = new boolean[totalStars][totalStars];
            block3: for (int i = 0; i < totalStars; ++i) {
                Object b;
                Vec3 a = starCenters[i];
                if (a == null || !starEntities[i].isStuck()) continue;
                ArrayList<EdgeCandidate> neighbors = new ArrayList<EdgeCandidate>();
                for (int j = 0; j < totalStars; ++j) {
                    if (i == j || (b = starCenters[j]) == null || !starEntities[j].isStuck()) continue;
                    double dx = a.x - ((Vec3)b).x;
                    double dy = a.y - ((Vec3)b).y;
                    double dz = a.z - ((Vec3)b).z;
                    neighbors.add(new EdgeCandidate(i, j, dx * dx + dy * dy + dz * dz));
                }
                neighbors.sort(Comparator.comparingDouble(e -> e.weightSquared));
                int connections = 0;
                b = neighbors.iterator();
                while (b.hasNext()) {
                    EdgeCandidate candidate = (EdgeCandidate)b.next();
                    if (connections >= 2) continue block3;
                    int u = candidate.indexU;
                    int v = candidate.indexV;
                    if (exists[u][v]) continue;
                    edges.add(new int[]{u, v});
                    exists[v][u] = true;
                    exists[u][v] = true;
                    ++connections;
                }
            }
            for (int[] edge : edges) {
                if (edge[0] != originIndex) continue;
                Vec3 a = starCenters[edge[0]];
                Vec3 b = starCenters[edge[1]];
                if (a == null || b == null) continue;
                Vec3 dir = b.subtract(a);
                double length = dir.length();
                Vec3 dirNorm = dir.scale(1.0 / length);
                double proximityThreshold = 0.5;
                AABB segmentBox = new AABB(Math.min(a.x(), b.x()) - proximityThreshold, Math.min(a.y(), b.y()) - proximityThreshold, Math.min(a.z(), b.z()) - proximityThreshold, Math.max(a.x(), b.x()) + proximityThreshold, Math.max(a.y(), b.y()) + proximityThreshold, Math.max(a.z(), b.z()) + proximityThreshold);
                boolean crossed = false;
                for (LivingEntity entity2 : level.getEntitiesOfClass(LivingEntity.class, segmentBox, entity -> entity != this.getOwner())) {
                    Item item;
                    if (!entity2.getBoundingBox().clip(a, b).isPresent()) continue;
                    crossed = true;
                    entity2.addEffect(new MobEffectInstance(RelicsMobEffects.TREMOR, (int)(this.getTremor() * 20.0f), 0));
                    if (entity2.tickCount % 20 != 0 || !((item = this.stack.getItem()) instanceof MidnightMantleItem)) continue;
                    MidnightMantleItem relic = (MidnightMantleItem)item;
                    item = this.getOwner();
                    if (!(item instanceof LivingEntity)) continue;
                    LivingEntity owner = (LivingEntity)item;
                    relic.addRelicExperience(owner, this.stack, "constellation", "star_tremor", 1.0);
                }
                if (!level.isClientSide()) continue;
                double particleSpacing = 0.15;
                Vec3 up = new Vec3(0.0, 1.0, 0.0);
                Vec3 u = dirNorm.cross(up);
                if (u.length() < 1.0E-4) {
                    u = dirNorm.cross(new Vec3(1.0, 0.0, 0.0));
                }
                u = u.normalize();
                Vec3 v = dirNorm.cross(u).normalize();
                int stepCount = Math.max(1, (int)Math.ceil(length / particleSpacing));
                double amplitude = 0.05;
                double wavelength = 2.0;
                double speed = 0.05;
                double time = (double)(level.getGameTime() + (long)this.getId()) * speed;
                for (int step = 0; step <= stepCount; ++step) {
                    ParticleOptions data;
                    Color color;
                    double f = (double)step / (double)stepCount;
                    Vec3 basePos = a.add(dir.scale(f));
                    double phase = f * length / wavelength * 2.0 * Math.PI + time;
                    Vec3 offset = u.scale(Math.cos(phase) * amplitude).add(v.scale(Math.sin(phase) * amplitude));
                    Vec3 pos = basePos.add(offset);
                    if (crossed) {
                        color = new Color(255, this.random.nextInt(50), 0);
                        data = ParticleUtils.constructSimpleSpark(color, 0.25f, 5, 0.9f);
                        float motion = 0.05f;
                        level.addParticle(data, true, pos.x, pos.y, pos.z, (double)(MathUtils.randomFloat(this.random) * motion), (double)(MathUtils.randomFloat(this.random) * motion), (double)(MathUtils.randomFloat(this.random) * motion));
                        continue;
                    }
                    color = this.isFlawless() ? new Color(200 + this.random.nextInt(50), 150 + this.random.nextInt(50), 0) : new Color(50 + this.random.nextInt(50), 50 + this.random.nextInt(150), 255);
                    data = ParticleUtils.constructSimpleSpark(color, 0.25f, 0, 1.0f);
                    level.addParticle(data, true, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (this.level().isClientSide() || this.noPhysics) {
            return;
        }
        Vec3 vec = result.getLocation();
        Direction face = result.getDirection();
        double pushBack = -0.1;
        double x = vec.x() - (double)face.getStepX() * pushBack;
        double y = vec.y() - (double)face.getStepY() * pushBack;
        double z = vec.z() - (double)face.getStepZ() * pushBack;
        this.setDeltaMovement(Vec3.ZERO);
        this.setNoGravity(true);
        this.setPos(x, y, z);
        this.setStuck(true);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide()) {
            return false;
        }
        Entity owner = this.getOwner();
        Entity attacker = source.getEntity();
        if (owner != null && attacker != null && owner.getStringUUID().equals(attacker.getStringUUID())) {
            return false;
        }
        this.playSound(SoundEvents.SHULKER_BULLET_HURT, 1.0f, 1.0f);
        this.discard();
        return true;
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        Level level = this.level();
        RandomSource random = level.getRandom();
        Vec3 position = this.position();
        for (LivingEntity target : level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)this.getExplosionRadius()), entity -> this.getOwner() == null || !this.getOwner().getStringUUID().equals(entity.getStringUUID()))) {
            ConstellationStarEntity constellationStarEntity;
            target.invulnerableTime = 0;
            float damage = this.getDamage();
            DamageSources damageSources = this.level().damageSources();
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                constellationStarEntity = owner;
            } else {
                constellationStarEntity = this;
            }
            if (!target.hurt(damageSources.thrown((Entity)constellationStarEntity, (Entity)this), damage)) continue;
            float stun = this.getStun();
            target.addEffect(new MobEffectInstance(RelicsMobEffects.STUN, (int)(stun * 20.0f), 0));
            Item item = this.stack.getItem();
            if (!(item instanceof MidnightMantleItem)) continue;
            MidnightMantleItem relic = (MidnightMantleItem)item;
            item = this.getOwner();
            if (!(item instanceof LivingEntity)) continue;
            LivingEntity owner = (LivingEntity)item;
            relic.addAbilityMetricValue(owner, this.stack, "constellation", "star_damage", damage);
            relic.addRelicExperience(owner, this.stack, "constellation", "star_damage", damage);
            if (!(stun > 0.0f)) continue;
            relic.addAbilityMetricValue(owner, this.stack, "constellation", "star_stun", stun);
        }
        int ringParticleCount = 100 + random.nextInt(50);
        for (int i = 0; i < ringParticleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)ringParticleCount;
            Vec3 velocity = new Vec3(Math.cos(angle), 0.15 + random.nextDouble() * 0.1, Math.sin(angle)).normalize().scale(0.05 + random.nextDouble() * 0.05);
            Color color = this.isFlawless() ? new Color(255, 215, 0) : new Color(50 + random.nextInt(150), 50 + random.nextInt(150), 255);
            level.addParticle(ParticleUtils.constructSimpleSpark(color, 0.75f + random.nextFloat() * 0.25f, 50 + random.nextInt(25), 0.95f), true, position.x, position.y, position.z, velocity.x, velocity.y, velocity.z);
        }
        int burstParticleCount = 250 + random.nextInt(100);
        for (int i = 0; i < burstParticleCount; ++i) {
            Vec3 velocity = new Vec3(random.nextGaussian(), random.nextGaussian(), random.nextGaussian()).normalize().scale(0.1 + random.nextDouble() * 0.1);
            Color color = this.isFlawless() ? new Color(255, 235, 100) : new Color(100 + random.nextInt(155), 100 + random.nextInt(155), 255);
            ParticleOptions spark = ParticleUtils.constructSimpleSpark(color, 0.25f + random.nextFloat(), 20 + random.nextInt(10), 0.9f);
            level.addParticle(spark, true, position.x, position.y, position.z, velocity.x, velocity.y, velocity.z);
        }
        int trailCount = 10;
        int pointCount = 25;
        double maxDistance = 2.5;
        for (int i = 0; i < trailCount; ++i) {
            Vec3 direction = new Vec3(random.nextGaussian(), random.nextDouble(), random.nextGaussian()).normalize();
            for (int j = 1; j <= pointCount; ++j) {
                double t = (double)j / (double)pointCount;
                double spacedT = Math.pow(t, 1.5);
                double px = position.x + direction.x * spacedT * maxDistance;
                double py = position.y + direction.y * spacedT * maxDistance;
                double pz = position.z + direction.z * spacedT * maxDistance;
                Color color = this.isFlawless() ? new Color(255, 200, 50) : new Color(80 + random.nextInt(100), 80 + random.nextInt(100), 255);
                ParticleOptions spark = ParticleUtils.constructSimpleSpark(color, (float)(1.0 * (1.0 - t) + (double)0.1f), 15 + random.nextInt(15), 0.5f);
                level.addParticle(spark, true, px, py, pz, direction.x * 0.02, direction.y * 0.02, direction.z * 0.02);
            }
        }
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isOnFire() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LIFETIME, (Object)0);
        builder.define(CONSTELLATION, (Object)"");
        builder.define(STUCK, (Object)false);
        builder.define(FLAWLESS, (Object)false);
        builder.define(TREMOR, (Object)Float.valueOf(0.0f));
        builder.define(STUN, (Object)Float.valueOf(0.0f));
        builder.define(CONSTELLATION_RADIUS, (Object)Float.valueOf(0.0f));
        builder.define(EXPLOSION_RADIUS, (Object)Float.valueOf(0.0f));
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("lifetime", this.getLifetime());
        tag.putBoolean("stuck", this.isStuck());
        tag.putBoolean("flawless", this.isFlawless());
        tag.putFloat("tremor", this.getTremor());
        tag.putFloat("stun", this.getStun());
        tag.putFloat("constellation_radius", this.getConstellationRadius());
        tag.putFloat("explosion_radius", this.getExplosionRadius());
        tag.putFloat("damage", this.getDamage());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setLifetime(tag.getInt("lifetime"));
        this.setStuck(tag.getBoolean("stuck"));
        this.setFlawless(tag.getBoolean("flawless"));
        this.setTremor(tag.getFloat("tremor"));
        this.setStun(tag.getFloat("stun"));
        this.setConstellationRadius(tag.getFloat("constellation_radius"));
        this.setExplosionRadius(tag.getFloat("explosion_radius"));
        this.setDamage(tag.getFloat("damage"));
    }

    protected double getDefaultGravity() {
        return 0.03;
    }

    @Generated
    public ItemStack getStack() {
        return this.stack;
    }

    @Generated
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    private static class EdgeCandidate {
        final int indexU;
        final int indexV;
        final double weightSquared;

        @Generated
        public EdgeCandidate(int indexU, int indexV, double weightSquared) {
            this.indexU = indexU;
            this.indexV = indexV;
            this.weightSquared = weightSquared;
        }
    }
}

