/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities.relic.midnight_mantle;

import it.hurts.sskirillss.relics.entities.MidnightMantleShockwaveBlockEntity;
import it.hurts.sskirillss.relics.entities.ShockwaveBlockEntity;
import it.hurts.sskirillss.relics.init.RelicsEntities;
import it.hurts.sskirillss.relics.init.RelicsSounds;
import it.hurts.sskirillss.relics.items.relics.back.MidnightMantleItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.S2CSpawnParticle;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.hurts.sskirillss.relics.utils.ServerScheduler;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class FallingStarEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> BOUNCE_CHANCE = SynchedEntityData.defineId(FallingStarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.defineId(FallingStarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(FallingStarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> STUN = SynchedEntityData.defineId(FallingStarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FLAWLESS = SynchedEntityData.defineId(FallingStarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ItemStack stack = ItemStack.EMPTY;
    private boolean bounced = false;
    private int bounces = 0;

    public void setBounceChance(float bounceChance) {
        this.getEntityData().set(BOUNCE_CHANCE, (Object)Float.valueOf(bounceChance));
    }

    public float getBounceChance() {
        return ((Float)this.getEntityData().get(BOUNCE_CHANCE)).floatValue();
    }

    public void setRadius(int radius) {
        this.getEntityData().set(RADIUS, (Object)radius);
    }

    public int getRadius() {
        return (Integer)this.getEntityData().get(RADIUS);
    }

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public void setStun(int stun) {
        this.getEntityData().set(STUN, (Object)stun);
    }

    public int getStun() {
        return (Integer)this.getEntityData().get(STUN);
    }

    public void setFlawless(boolean flawless) {
        this.getEntityData().set(FLAWLESS, (Object)flawless);
    }

    public boolean isFlawless() {
        return (Boolean)this.getEntityData().get(FLAWLESS);
    }

    public FallingStarEntity(EntityType<? extends FallingStarEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void tick() {
        Vec3 motion;
        super.tick();
        Level level = this.level();
        int ringInterval = 2;
        double prevX = this.xOld;
        double prevY = this.yOld + (double)(this.getBbHeight() / 2.0f);
        double prevZ = this.zOld;
        double currX = this.getX();
        double currY = this.getY() + (double)(this.getBbHeight() / 2.0f);
        double currZ = this.getZ();
        double dx = currX - prevX;
        double dy = currY - prevY;
        double dz = currZ - prevZ;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double step = 0.1;
        int segments = (int)Math.ceil(distance / step);
        float swirlRadius = 0.01f;
        Color blueStart = new Color(50, 100, 255);
        Color blueEnd = new Color(150, 200, 255);
        for (int i = 0; i <= segments; ++i) {
            float t = segments > 0 ? (float)i / (float)segments : 0.0f;
            double bx = prevX + dx * (double)t;
            double by = prevY + dy * (double)t;
            double bz = prevZ + dz * (double)t;
            float vx = (float)(Math.cos((double)t * Math.PI * 2.0) * (double)swirlRadius);
            float vz = (float)(Math.sin((double)t * Math.PI * 2.0) * (double)swirlRadius);
            float vy = swirlRadius;
            int r = (int)((float)blueStart.getRed() * (1.0f - t) + (float)blueEnd.getRed() * t);
            int g = (int)((float)blueStart.getGreen() * (1.0f - t) + (float)blueEnd.getGreen() * t);
            int b = (int)((float)blueStart.getBlue() * (1.0f - t) + (float)blueEnd.getBlue() * t);
            Color color = new Color(r, g, b);
            level.addParticle(ParticleUtils.constructSimpleSpark(this.isFlawless() ? new Color(200 + this.random.nextInt(50), 150 + this.random.nextInt(50), 0) : color, 0.5f, 30, 0.925f), true, bx, by, bz, (double)vx, (double)vy, (double)vz);
        }
        if (this.tickCount % ringInterval == 0 && (motion = this.getDeltaMovement()).lengthSqr() > 1.0E-6) {
            Vec3 dir = motion.normalize();
            Vec3 v1 = dir.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
            if (v1.lengthSqr() < 1.0E-6) {
                v1 = dir.cross(new Vec3(1.0, 0.0, 0.0)).normalize();
            }
            Vec3 v2 = dir.cross(v1).normalize();
            int ringCount = 50;
            float ringRadius = 0.25f;
            float radialSpeed = 0.05f;
            float tangentialSpeed = 0.02f;
            float upwardSpeed = 0.001f;
            Color purpleStart = new Color(128, 0, 255);
            Color purpleEnd = new Color(255, 128, 255);
            for (int j = 0; j < ringCount; ++j) {
                double a = Math.PI * 2 * (double)j / (double)ringCount;
                Vec3 offset = v1.scale((double)((float)Math.cos(a) * ringRadius)).add(v2.scale((double)((float)Math.sin(a) * ringRadius)));
                double px = currX + offset.x;
                double py = currY + offset.y;
                double pz = currZ + offset.z;
                Vec3 radial = offset.normalize();
                Vec3 tangential = radial.cross(dir).normalize();
                Vec3 vel = radial.scale((double)radialSpeed).add(tangential.scale((double)tangentialSpeed)).add(new Vec3(0.0, (double)upwardSpeed, 0.0));
                float tRing = (float)j / (float)(ringCount - 1);
                int rr = (int)((float)purpleStart.getRed() * (1.0f - tRing) + (float)purpleEnd.getRed() * tRing);
                int rg = (int)((float)purpleStart.getGreen() * (1.0f - tRing) + (float)purpleEnd.getGreen() * tRing);
                int rb = (int)((float)purpleStart.getBlue() * (1.0f - tRing) + (float)purpleEnd.getBlue() * tRing);
                Color ringColor = new Color(rr, rg, rb);
                level.addParticle(ParticleUtils.constructSimpleSpark(this.isFlawless() ? new Color(200 + this.random.nextInt(50), 150 + this.random.nextInt(50), 0) : ringColor, 0.5f, 20, 0.9f), true, px, py, pz, (double)((float)vel.x), (double)((float)vel.y), (double)((float)vel.z));
            }
        }
        if (!level.isClientSide() && this.tickCount > 250 + this.bounces * 150) {
            this.discard();
        }
        this.bounced = false;
    }

    protected void onHitBlock(BlockHitResult result) {
        BlockPos center = result.getBlockPos();
        Level level = this.level();
        if (level.isClientSide() || this.noPhysics || !level.getBlockState(center).blocksMotion()) {
            return;
        }
        int radius = Math.max(this.getRadius() - this.bounces, 1);
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        for (int i = -radius; i <= radius; ++i) {
            int r1 = (int)Mth.sqrt((float)(radius * radius - i * i));
            for (int j = -r1; j <= r1; ++j) {
                poses.add(center.offset(i, 0, j));
            }
        }
        int step = 0;
        while (step <= radius) {
            int finalStep = step++;
            ServerScheduler.schedule(finalStep, () -> {
                float height = 0.25f;
                Random localRandom = new Random();
                poses.stream().filter(pos -> {
                    int dz;
                    int dx = pos.getX() - center.getX();
                    double dist = Math.hypot(dx, dz = pos.getZ() - center.getZ());
                    return dist >= (double)finalStep && dist < (double)(finalStep + 1);
                }).forEach(entryPos -> {
                    int centerY = center.getY();
                    int maxOffset = 8;
                    int groundY = WorldUtils.findSurfaceY(level, entryPos.getX(), entryPos.getZ(), centerY, maxOffset);
                    int minAllowedY = Math.max(level.getMinBuildHeight(), centerY - maxOffset);
                    int maxAllowedY = Math.min(level.getMaxBuildHeight(), centerY + maxOffset);
                    if (groundY < minAllowedY || groundY > maxAllowedY) {
                        return;
                    }
                    BlockPos surfacePos = new BlockPos(entryPos.getX(), groundY, entryPos.getZ());
                    MidnightMantleShockwaveBlockEntity shockwave = new MidnightMantleShockwaveBlockEntity((EntityType<? extends ShockwaveBlockEntity>)((EntityType)RelicsEntities.SHOCKWAVE_BLOCK.get()), level);
                    shockwave.setPos((float)surfacePos.getX() + 0.5f, surfacePos.getY(), (float)surfacePos.getZ() + 0.5f);
                    shockwave.setBlockState(level.getBlockState(surfacePos));
                    shockwave.setDeltaMovement(0.0, height, 0.0);
                    shockwave.setDamage(this.getDamage());
                    shockwave.setOwner(this.getOwner());
                    shockwave.setStack(this.getStack());
                    shockwave.setStun(this.getStun());
                    shockwave.setCenter(surfacePos);
                    shockwave.setKnockback(0.75f);
                    level.addFreshEntity((Entity)shockwave);
                    for (int i = 0; i < 5; ++i) {
                        double angle = (double)localRandom.nextFloat() * Math.PI * 2.0;
                        float rad = (float)finalStep + 0.5f + (localRandom.nextFloat() - 0.5f) * 0.3f;
                        float px = (float)((double)surfacePos.getX() + Math.cos(angle) * (double)rad + 0.5) + MathUtils.randomFloat(this.random) * 0.5f;
                        float py = (float)surfacePos.getY() + 1.0f + localRandom.nextFloat() * 0.2f + MathUtils.randomFloat(this.random) * 0.5f;
                        float pz = (float)((double)surfacePos.getZ() + Math.sin(angle) * (double)rad + 0.5) + MathUtils.randomFloat(this.random) * 0.5f;
                        float vx = (float)Math.cos(angle) * 0.1f;
                        float vy = (float)finalStep * 0.025f + localRandom.nextFloat() * 0.05f;
                        float vz = (float)Math.sin(angle) * 0.1f;
                        NetworkHandler.sendToClientsTrackingEntity(new S2CSpawnParticle(ParticleUtils.constructSimpleSpark(this.isFlawless() ? new Color(200 + this.random.nextInt(50), 150 + this.random.nextInt(50), 0) : new Color(50 + this.random.nextInt(50), 50 + this.random.nextInt(100), 255), 0.35f + this.random.nextFloat() * 0.25f, 10 + this.random.nextInt(20), 0.9f), new Vector3f(px, py, pz), new Vector3f(vx, vy, vz)), (Entity)shockwave);
                    }
                });
            });
        }
        level.playSound(null, this.blockPosition(), (SoundEvent)RelicsSounds.FALLING_STAR_FALL.get(), SoundSource.MASTER, 0.5f, 1.0f + this.random.nextFloat() + (float)this.bounces * 0.2f);
        float bounceChance = this.getBounceChance();
        if (bounceChance > 0.0f) {
            if (this.bounced) {
                return;
            }
            if (this.random.nextFloat() <= bounceChance) {
                Vec3 normal = Vec3.atLowerCornerOf((Vec3i)result.getDirection().getNormal()).normalize();
                Vec3 motion = this.getDeltaMovement();
                Vec3 reflected = motion.subtract(normal.scale(2.0 * motion.dot(normal))).normalize().scale((double)(0.5f + (float)this.getRadius() * 0.075f));
                this.setDeltaMovement(reflected);
                this.bounced = true;
                ++this.bounces;
                ItemStack stack = this.getStack();
                Item item = stack.getItem();
                if (item instanceof MidnightMantleItem) {
                    MidnightMantleItem relic = (MidnightMantleItem)item;
                    item = this.getOwner();
                    if (item instanceof LivingEntity) {
                        LivingEntity owner = (LivingEntity)item;
                        relic.addAbilityMetricValue(owner, stack, "starfall", "star_bounces", 1.0);
                        relic.addRelicExperience(owner, stack, "starfall", "star_bounce", 1.0);
                    }
                }
            } else {
                this.discard();
            }
        } else {
            this.discard();
        }
    }

    public boolean isOnFire() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BOUNCE_CHANCE, (Object)Float.valueOf(0.0f));
        builder.define(RADIUS, (Object)1);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(STUN, (Object)0);
        builder.define(FLAWLESS, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("bounce_chance", this.getBounceChance());
        tag.putInt("radius", this.getRadius());
        tag.putFloat("damage", this.getDamage());
        tag.putInt("stun", this.getStun());
        tag.putBoolean("flawless", this.isFlawless());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBounceChance(tag.getFloat("bounce_chance"));
        this.setRadius(tag.getInt("radius"));
        this.setDamage(tag.getFloat("damage"));
        this.setStun(tag.getInt("stun"));
        this.setFlawless(tag.getBoolean("flawless"));
    }

    protected double getDefaultGravity() {
        return 0.03;
    }

    @Generated
    public ItemStack getStack() {
        return this.stack;
    }

    @Generated
    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

