/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.init.RelicsCreativeTabs;
import it.hurts.sskirillss.relics.init.RelicsDataComponents;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import it.hurts.sskirillss.relics.items.misc.CreativeContentConstructor;
import it.hurts.sskirillss.relics.items.misc.ICreativeTabContent;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.S2CSetEntityMotion;
import it.hurts.sskirillss.relics.utils.FlawlessUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.hurts.sskirillss.relics.utils.ServerScheduler;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

public class ChorusStaffItem
extends RelicItem
implements ICreativeTabContent {
    @Override
    public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(AbilitiesTemplate.builder().ability(AbilityTemplate.builder("blink").rankModifier(1, "flicker").rankModifier(3, "safe_fall").rankModifier(5, "ascent").initialMaxLevel(10).stat(StatTemplate.builder("distance").initialValue(10.0, 15.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0286).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatTemplate.builder("max_charge").initialValue(3.0, 5.0).upgradeModifier(RelicsScalingModels.ADDITIVE.get(), 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatTemplate.builder("cooldown").initialValue(30.0, 15.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), -0.019).formatValue(value -> (int)MathUtils.round(value, 0)).build()).experienceSources(ExperienceSourcesTemplate.builder().source("blink").source(ExperienceSourceTemplate.builder("flicker").rankModifierVisibilityState("flicker", VisibilityState.OBFUSCATED).build()).source(ExperienceSourceTemplate.builder("safe_fall").rankModifierVisibilityState("safe_fall", VisibilityState.OBFUSCATED).build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("blinks_amount").formatValue(value -> String.valueOf(value.intValue())).build()).metric(AbilityMetricTemplate.builder("distance_traveled").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).metric(AbilityMetricTemplate.builder("targets").formatValue(value -> String.valueOf(value.intValue())).rankModifierVisibilityState("flicker", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("safe_falls").formatValue(value -> String.valueOf(value.intValue())).rankModifierVisibilityState("safe_fall", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 14, 4).star(1, 8, 6).star(2, 19, 13).star(3, 12, 14).star(4, 3, 15).star(5, 7, 22).star(6, 14, 22).star(7, 7, 28).link(7, 5).link(5, 4).link(5, 6).link(5, 3).link(3, 2).link(3, 1).link(3, 0).build()).build()).build()).leveling(LevelingTemplate.builder().initialCost(100.0).step(200.0).build()).style(StyleTemplate.builder().tooltip(TooltipData.builder().borderTop(-12840400).borderBottom(-11252448).textured(true).build()).build()).loot(LootTemplate.builder().entry(LootEntries.END_LIKE, LootEntries.THE_END).build()).build();
    }

    public int getMaxCharge(LivingEntity entity, ItemStack stack) {
        return (int)this.getStatValue(entity, stack, "blink", "max_charge");
    }

    public int getCharge(LivingEntity entity, ItemStack stack) {
        return Math.clamp((long)((Integer)stack.getOrDefault(RelicsDataComponents.CHORUS_STAFF_CHARGE, (Object)0)).intValue(), 0, this.getMaxCharge(entity, stack));
    }

    public void setCharge(LivingEntity entity, ItemStack stack, int charge) {
        stack.set(RelicsDataComponents.CHORUS_STAFF_CHARGE, (Object)Math.clamp((long)charge, 0, this.getMaxCharge(entity, stack)));
    }

    public void addCharge(LivingEntity entity, ItemStack stack, int charge) {
        this.setCharge(entity, stack, this.getCharge(entity, stack) + charge);
    }

    public void setSafeFall(ItemStack stack, boolean state) {
        stack.set(RelicsDataComponents.CHORUS_STAFF_SAFE_FALL, (Object)state);
    }

    public boolean shouldSafeFall(ItemStack stack) {
        return (Boolean)stack.getOrDefault(RelicsDataComponents.CHORUS_STAFF_SAFE_FALL, (Object)false);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.canPlayerUseAbility((LivingEntity)player, stack, "blink")) {
            return InteractionResultHolder.pass((Object)stack);
        }
        double radius = this.getStatValue((LivingEntity)player, stack, "blink", "distance");
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookAngle = player.getLookAngle().normalize();
        Vec3 destination = eyePos.add(lookAngle.scale(radius));
        BlockHitResult hit = level.clip(new ClipContext(eyePos, destination, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 impulse = Vec3.ZERO;
        int charge = this.getCharge((LivingEntity)player, stack);
        if (charge <= 0) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (this.isAbilityRankModifierUnlocked((LivingEntity)player, stack, "blink", "ascent") && hit.getType() == HitResult.Type.BLOCK && hit.getLocation().distanceTo(eyePos) <= radius) {
            BlockPos current = hit.getBlockPos();
            int maxUp = (int)Math.floor(radius - eyePos.distanceTo(hit.getLocation()));
            BlockPos feetPos = null;
            for (int i = 1; i <= maxUp && current.getY() + i < level.getMaxBuildHeight(); ++i) {
                BlockPos feet = current.above(i);
                BlockPos head = feet.above();
                if (!level.isEmptyBlock(feet) || !level.isEmptyBlock(head)) continue;
                feetPos = feet;
                break;
            }
            destination = feetPos != null ? feetPos.getBottomCenter() : hit.getLocation().subtract(lookAngle.scale(0.5));
        } else {
            destination = hit.getLocation();
            if (!level.getBlockState(hit.getBlockPos().below()).blocksMotion()) {
                destination = destination.add(0.0, -1.0, 0.0);
            }
            double extra = Math.min(player.getKnownMovement().length(), 5.0);
            impulse = lookAngle.scale(1.25 + extra);
        }
        RandomSource random = level.getRandom();
        float shift = player.getBbHeight() / 2.0f;
        Vec3 from = player.position().add(0.0, (double)shift, 0.0);
        Vec3 to = destination.add(0.0, (double)shift, 0.0);
        level.playSound(player, new BlockPos((int)from.x(), (int)from.y(), (int)from.z()), SoundEvents.ENDERMAN_TELEPORT, SoundSource.MASTER, 1.0f, 1.0f);
        level.playSound(player, new BlockPos((int)to.x(), (int)to.y(), (int)to.z()), SoundEvents.ENDERMAN_TELEPORT, SoundSource.MASTER, 1.0f, 1.0f);
        if (!level.isClientSide) {
            ServerScheduler.schedule(1, () -> {
                Vec3 direction = to.subtract(from);
                double dist = Math.max(0.001, direction.length());
                Vec3 forward = direction.scale(1.0 / dist);
                Vec3 up = Math.abs(forward.y) < 0.99 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
                Vec3 right = forward.cross(up).normalize();
                Vec3 binormal = forward.cross(right).normalize();
                int pointCount = (int)Math.round(dist);
                Vec3[] points = new Vec3[pointCount];
                for (int i = 0; i < pointCount; ++i) {
                    float t = (float)i / (float)(pointCount - 1);
                    Vec3 base = new Vec3(Mth.lerp((double)t, (double)from.x, (double)to.x), Mth.lerp((double)t, (double)from.y, (double)to.y), Mth.lerp((double)t, (double)from.z, (double)to.z));
                    float wobble = 1.0f + 0.5f * (float)Math.sin((double)t * Math.PI);
                    float ox = (random.nextFloat() - 0.5f) * wobble;
                    float oy = (random.nextFloat() - 0.5f) * wobble;
                    points[i] = base.add(right.scale((double)ox)).add(binormal.scale((double)oy));
                }
                int segments = 12;
                for (int i = 0; i < pointCount - 1; ++i) {
                    Vec3 p0 = points[i];
                    Vec3 p1 = points[i + 1];
                    for (int s = 0; s <= segments; ++s) {
                        float t = (float)s / (float)segments;
                        double px = Mth.lerp((double)t, (double)p0.x, (double)p1.x);
                        double py = Mth.lerp((double)t, (double)p0.y, (double)p1.y);
                        double pz = Mth.lerp((double)t, (double)p0.z, (double)p1.z);
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles(ParticleUtils.constructSimpleSpark(FlawlessUtils.getColor((LivingEntity)player, stack, new Color(155 + random.nextInt(100), 80, 255)), 1.0f, 3, 0.5f), px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            });
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.teleportTo((ServerLevel)level, destination.x, destination.y, destination.z, player.getYRot(), player.getXRot());
                serverPlayer.fallDistance = 0.0f;
                NetworkHandler.sendToClient(new S2CSetEntityMotion(player.getId(), impulse.toVector3f()), serverPlayer);
                Vec3 finalImpulse = impulse;
                ServerScheduler.schedule(1, () -> NetworkHandler.sendToClient(new S2CSetEntityMotion(player.getId(), finalImpulse.toVector3f()), serverPlayer));
                this.addCharge((LivingEntity)player, stack, -1);
                this.addRelicExperience((LivingEntity)player, stack, "blink", "blink", 1.0);
                this.addAbilityMetricValue((LivingEntity)player, stack, "blink", "blinks_amount", 1.0);
                this.addAbilityMetricValue((LivingEntity)player, stack, "blink", "distance_traveled", from.distanceTo(to));
                if (this.isAbilityRankModifierUnlocked((LivingEntity)player, stack, "blink", "safe_fall")) {
                    this.setSafeFall(stack, true);
                }
                if (this.isAbilityRankModifierUnlocked((LivingEntity)player, stack, "blink", "flicker")) {
                    for (Mob mob : level.getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate(32.0))) {
                        if (mob.getTarget() != player) continue;
                        mob.setTarget(null);
                        this.addRelicExperience((LivingEntity)player, stack, "blink", "flicker", 1.0);
                        this.addAbilityMetricValue((LivingEntity)player, stack, "blink", "targets", 1.0);
                    }
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        LivingEntity livingEntity;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (level.isClientSide() || !(entity instanceof LivingEntity) || livingEntity.tickCount % ((int)this.getStatValue(livingEntity = (LivingEntity)entity, stack, "blink", "cooldown") * 20) != 0 || this.getCharge(livingEntity, stack) >= this.getMaxCharge(livingEntity, stack)) {
            return;
        }
        this.addCharge(livingEntity, stack, 1);
    }

    @Override
    public void gatherCreativeTabContent(CreativeContentConstructor constructor) {
        ItemStack stack = this.getDefaultInstance();
        this.setCharge(null, stack, this.getMaxCharge(null, stack));
        constructor.entry((CreativeModeTab)RelicsCreativeTabs.RELICS_TAB.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, stack);
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)this.getCharge(null, stack) / (float)this.getMaxCharge(null, stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.ceil(13.0f * (float)this.getCharge(null, stack) / (float)this.getMaxCharge(null, stack));
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getCharge(null, stack) < this.getMaxCharge(null, stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxCharge(null, stack);
    }

    @EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ChorusStaffItem relic;
                ItemStack stack = inventory.getItem(i);
                Item item = stack.getItem();
                if (!(item instanceof ChorusStaffItem) || !(relic = (ChorusStaffItem)item).isAbilityRankModifierUnlocked((LivingEntity)player, stack, "blink", "safe_fall") || !relic.shouldSafeFall(stack)) continue;
                relic.setSafeFall(stack, false);
                relic.addRelicExperience((LivingEntity)player, stack, "blink", "blink", 1.0);
                relic.addAbilityMetricValue((LivingEntity)player, stack, "blink", "safe_falls", 1.0);
                event.setDamageMultiplier(0.0f);
            }
        }
    }
}

