/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.research;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import it.hurts.sskirillss.relics.items.relics.base.data.research.StarData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ResearchTemplate {
    private Map<Integer, StarData> stars;
    private Multimap<Integer, Integer> links;

    public List<StarData> getConnectedStars(StarData star) {
        ArrayList<StarData> connectedStars = new ArrayList<StarData>();
        int starIndex = star.getIndex();
        if (this.links.containsKey((Object)starIndex)) {
            for (Integer connectedIndex : this.links.get((Object)starIndex)) {
                connectedStars.add(this.stars.get(connectedIndex));
            }
        }
        for (Map.Entry entry : this.links.entries()) {
            if (!((Integer)entry.getValue()).equals(starIndex)) continue;
            connectedStars.add(this.stars.get(entry.getKey()));
        }
        return connectedStars;
    }

    @Generated
    ResearchTemplate(Map<Integer, StarData> stars, Multimap<Integer, Integer> links) {
        this.stars = stars;
        this.links = links;
    }

    @Generated
    public static ResearchTemplateBuilder builder() {
        return new ResearchTemplateBuilder();
    }

    @Generated
    public ResearchTemplateBuilder toBuilder() {
        return new ResearchTemplateBuilder().stars(this.stars).links(this.links);
    }

    @Generated
    public Map<Integer, StarData> getStars() {
        return this.stars;
    }

    @Generated
    public Multimap<Integer, Integer> getLinks() {
        return this.links;
    }

    @Generated
    public void setStars(Map<Integer, StarData> stars) {
        this.stars = stars;
    }

    @Generated
    public void setLinks(Multimap<Integer, Integer> links) {
        this.links = links;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResearchTemplate)) {
            return false;
        }
        ResearchTemplate other = (ResearchTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Integer, StarData> this$stars = this.getStars();
        Map<Integer, StarData> other$stars = other.getStars();
        if (this$stars == null ? other$stars != null : !((Object)this$stars).equals(other$stars)) {
            return false;
        }
        Multimap<Integer, Integer> this$links = this.getLinks();
        Multimap<Integer, Integer> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !this$links.equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResearchTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Integer, StarData> $stars = this.getStars();
        result = result * 59 + ($stars == null ? 43 : ((Object)$stars).hashCode());
        Multimap<Integer, Integer> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : $links.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResearchTemplate(stars=" + String.valueOf(this.getStars()) + ", links=" + String.valueOf(this.getLinks()) + ")";
    }

    public static class ResearchTemplateBuilder {
        private Map<Integer, StarData> stars = new HashMap<Integer, StarData>();
        private Multimap<Integer, Integer> links = LinkedHashMultimap.create();

        public ResearchTemplateBuilder star(int index, int x, int y) {
            this.stars.put(index, new StarData(index, x, y));
            return this;
        }

        public ResearchTemplateBuilder link(int first, int second) {
            int n;
            if (first > second) {
                int n2 = first + second;
                second = first;
                n = n2 - second;
            } else {
                n = first;
            }
            this.links.put((Object)n, (Object)second);
            return this;
        }

        @Generated
        ResearchTemplateBuilder() {
        }

        @Generated
        public ResearchTemplateBuilder stars(Map<Integer, StarData> stars) {
            this.stars = stars;
            return this;
        }

        @Generated
        public ResearchTemplateBuilder links(Multimap<Integer, Integer> links) {
            this.links = links;
            return this;
        }

        @Generated
        public ResearchTemplate build() {
            return new ResearchTemplate(this.stars, this.links);
        }

        @Generated
        public String toString() {
            return "ResearchTemplate.ResearchTemplateBuilder(stars=" + String.valueOf(this.stars) + ", links=" + String.valueOf(this.links) + ")";
        }
    }
}

