/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.init.RelicsDataComponents;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import it.hurts.sskirillss.relics.init.RelicsSounds;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.item.springy_boot.S2CBounceFromSurface;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import top.theillusivec4.curios.api.SlotContext;

public class SpringyBootItem
extends RelicItem {
    @Override
    public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(AbilitiesTemplate.builder().ability(AbilityTemplate.builder("bounce").rankModifier(1, "disappearance").rankModifier(3, "strike").rankModifier(5, "shockwave").stat(StatTemplate.builder("power").initialValue(0.5, 0.75).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 0.3488).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("damage_modifier").initialValue(0.05, 0.15).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.0667).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("radius").initialValue(1.0, 3.0).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 1.9534).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("damage").initialValue(2.5, 5.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1429).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("stun").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.2571).formatValue(value -> MathUtils.round(value, 1)).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("bounce").build()).source(ExperienceSourceTemplate.builder("strike").rankModifierVisibilityState("strike", VisibilityState.OBFUSCATED).build()).source(ExperienceSourceTemplate.builder("create_shockwave").rankModifierVisibilityState("shockwave", VisibilityState.OBFUSCATED).build()).source(ExperienceSourceTemplate.builder("shockwave_hit").rankModifierVisibilityState("shockwave", VisibilityState.OBFUSCATED).build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("bounce_duration").formatValue(value -> MathUtils.formatTime(value.intValue())).build()).metric(AbilityMetricTemplate.builder("primary_bounces").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("secondary_bounces").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("additional_damage").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("strike", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("shockwaves_amount").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).rankModifierVisibilityState("shockwave", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("shockwave_targets").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).rankModifierVisibilityState("shockwave", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("shockwave_damage").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("shockwave", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("shockwave_stun").formatValue(value -> MathUtils.formatTime(value.intValue())).rankModifierVisibilityState("shockwave", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 6, 11).star(1, 16, 13).star(2, 11, 22).star(3, 20, 23).star(4, 2, 24).star(5, 6, 29).star(6, 18, 29).link(5, 4).link(4, 2).link(2, 3).link(3, 6).link(2, 0).link(2, 1).build()).build()).build()).leveling(LevelingTemplate.builder().initialCost(100.0).step(100.0).build()).style(StyleTemplate.builder().tooltip(TooltipData.builder().borderTop(-7030496).borderBottom(-11437808).textured(true).build()).build()).loot(LootTemplate.builder().entry(LootEntries.MOUNTAIN).build()).build();
    }

    public int getBounceCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.SPRINGY_BOOT_BOUNCE_COOLDOWN, (Object)0);
    }

    public void setBounceCooldown(ItemStack stack, int cooldown) {
        stack.set(RelicsDataComponents.SPRINGY_BOOT_BOUNCE_COOLDOWN, (Object)Math.max(0, cooldown));
    }

    public void addBounceCooldown(ItemStack stack, int cooldown) {
        this.setBounceCooldown(stack, this.getBounceCooldown(stack) + cooldown);
    }

    public boolean isLeaped(ItemStack stack) {
        return (Boolean)stack.getOrDefault(RelicsDataComponents.SPRINGY_BOOT_LEAPED, (Object)false);
    }

    public void setLeaped(ItemStack stack, boolean leaped) {
        stack.set(RelicsDataComponents.SPRINGY_BOOT_LEAPED, (Object)leaped);
    }

    public int getLeaps(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.SPRINGY_BOOT_LEAPS, (Object)0);
    }

    public void setLeaps(ItemStack stack, int leaps) {
        stack.set(RelicsDataComponents.SPRINGY_BOOT_LEAPS, (Object)Math.max(0, leaps));
    }

    public void addLeaps(ItemStack stack, int leaps) {
        this.setLeaps(stack, this.getLeaps(stack) + leaps);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        block7: {
            int leaps;
            LivingEntity entity;
            block9: {
                block8: {
                    super.curioTick(slotContext, stack);
                    entity = slotContext.entity();
                    Level level = entity.level();
                    if (level.isClientSide()) {
                        return;
                    }
                    int cooldown = this.getBounceCooldown(stack);
                    boolean leaped = this.isLeaped(stack);
                    leaps = this.getLeaps(stack);
                    if (entity.tickCount % 20 == 0 && (leaped || leaps > 0)) {
                        this.addAbilityMetricValue(entity, stack, "bounce", "bounce_duration", 1.0);
                    }
                    if (cooldown > 0) {
                        this.addBounceCooldown(stack, -1);
                    }
                    if (!leaped) break block7;
                    if (entity.isInLiquid() || entity.isFallFlying()) break block8;
                    if (!(entity instanceof Player)) break block9;
                    Player player = (Player)entity;
                    if (!player.getAbilities().flying) break block9;
                }
                this.setLeaped(stack, false);
                this.setLeaps(stack, 0);
            }
            if (this.isAbilityRankModifierUnlocked(entity, stack, "bounce", "disappearance") && leaps <= 0) {
                entity.addEffect(new MobEffectInstance(RelicsMobEffects.VANISHING, 5, 0, false, false));
            }
        }
    }

    @EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
            LivingEntity entity = event.getEntity();
            Level level = entity.level();
            if (level.isClientSide()) {
                return;
            }
            double power = 0.0;
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.SPRINGY_BOOT.get())) {
                SpringyBootItem relic = (SpringyBootItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity, stack, "bounce") || relic.isLeaped(stack) || relic.getBounceCooldown(stack) > 0 || !entity.isShiftKeyDown()) continue;
                power += relic.getStatValue(entity, stack, "bounce", "power");
                relic.addAbilityMetricValue(entity, stack, "bounce", "primary_bounces", 1.0);
                relic.setLeaped(stack, true);
                relic.addBounceCooldown(stack, 5);
            }
            if (power > 0.0) {
                Vec3 lookAngle = entity.getLookAngle();
                if (lookAngle.y() < 0.0) {
                    lookAngle = new Vec3(lookAngle.x(), 0.0, lookAngle.z());
                }
                Vec3 motion = lookAngle.multiply(-1.0, 1.0, -1.0).add(0.0, 0.5, 0.0).normalize().scale(power);
                NetworkHandler.sendToClientsTrackingEntityAndSelf(new S2CBounceFromSurface(entity.getId(), motion.toVector3f()), (Entity)entity);
                level.playSound(null, entity.blockPosition(), (SoundEvent)RelicsSounds.SPRING_BOING.get(), SoundSource.MASTER, 5.0f, 0.5f);
            }
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent.Pre event) {
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity2 = (LivingEntity)entity;
            double totalModifier = 0.0;
            int totalLeaps = 0;
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity2, (Item)RelicsItems.SPRINGY_BOOT.get())) {
                SpringyBootItem relic = (SpringyBootItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity2, stack, "bounce") || !relic.isLeaped(stack) || !relic.isAbilityRankModifierUnlocked(entity2, stack, "bounce", "strike")) continue;
                int leaps = relic.getLeaps(stack);
                if (totalLeaps < leaps) {
                    totalLeaps = leaps;
                }
                double modifier = relic.getStatValue(entity2, stack, "bounce", "damage_modifier");
                totalModifier += modifier;
                double damage = (double)(event.getNewDamage() * (float)leaps) * modifier;
                relic.addAbilityMetricValue(entity2, stack, "bounce", "additional_damage", damage);
                relic.addRelicExperience(entity2, stack, "bounce", "strike", damage);
            }
            double damage = (double)(event.getNewDamage() * (float)totalLeaps) * totalModifier;
            event.setNewDamage((float)((double)event.getNewDamage() + damage));
        }
    }
}

