/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.entities.ElectricSparkEntity;
import it.hurts.sskirillss.relics.init.RelicsDataComponents;
import it.hurts.sskirillss.relics.init.RelicsEntities;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsMobEffects;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import top.theillusivec4.curios.api.SlotContext;

public class JellyfishNecklaceItem
extends RelicItem {
    @Override
    public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(AbilitiesTemplate.builder().ability(AbilityTemplate.builder("regeneration").initialMaxLevel(10).rankModifier(3, "retention").stat(StatTemplate.builder("max_health").initialValue(0.1, 0.2).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 0.3628).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("regeneration").initialValue(0.15, 0.35).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 0.4604).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("health_regeneration").build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("health_regenerated").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).build()).research(ResearchTemplate.builder().star(0, 11, 10).star(1, 3, 9).star(2, 19, 9).star(3, 2, 16).star(4, 11, 16).star(5, 20, 16).star(6, 11, 24).link(0, 2).link(2, 5).link(5, 6).link(6, 3).link(3, 1).link(1, 0).link(0, 4).link(4, 6).link(3, 4).link(4, 5).build()).build()).ability(AbilityTemplate.builder("shock").initialMaxLevel(10).rankModifier(1, "conductor").rankModifier(5, "charge").modes("enabled", "disabled").stat(StatTemplate.builder("cooldown").initialValue(120.0, 60.0).thresholdValue(0.0, Double.MAX_VALUE).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), -13.9528).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("rings").initialValue(1.0, 2.0).thresholdValue(0.0, Double.MAX_VALUE).upgradeModifier(RelicsScalingModels.ADDITIVE.get(), 0.2286).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatTemplate.builder("radius").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.RADICAL.get(), 0.7606).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("knockback").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.EXPONENTIAL.get(), 0.0471).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("paralysis").initialValue(1.0, 2.5).upgradeModifier(RelicsScalingModels.EXPONENTIAL.get(), 0.0404).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("distance").initialValue(2.5, 5.0).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 4.1858).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("bounces").initialValue(1.0, 3.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.2095).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatTemplate.builder("damage").initialValue(2.5, 5.0).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 4.1858).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("damage_modifier").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.EXPONENTIAL.get(), 0.068).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("duration").initialValue(2.5, 5.0).upgradeModifier(RelicsScalingModels.RADICAL.get(), 4.2258).formatValue(value -> MathUtils.round(value, 1)).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("rings_accumulating").modeVisibilityState("disabled", VisibilityState.HIDDEN).build()).source(ExperienceSourceTemplate.builder("arcs_bouncing").modeVisibilityState("disabled", VisibilityState.HIDDEN).build()).source(ExperienceSourceTemplate.builder("hit_paralysis").rankModifierVisibilityState("charge", VisibilityState.OBFUSCATED).modeVisibilityState("disabled", VisibilityState.HIDDEN).build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("rings_accumulated").modeVisibilityState("disabled", VisibilityState.HIDDEN).formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("rings_paralysis").modeVisibilityState("disabled", VisibilityState.HIDDEN).formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).metric(AbilityMetricTemplate.builder("arcs_spawned").modeVisibilityState("disabled", VisibilityState.HIDDEN).formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("arcs_bounces").modeVisibilityState("disabled", VisibilityState.HIDDEN).formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("arcs_damage").modeVisibilityState("disabled", VisibilityState.HIDDEN).formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).metric(AbilityMetricTemplate.builder("hit_paralysis").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).modeVisibilityState("disabled", VisibilityState.HIDDEN).rankModifierVisibilityState("charge", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 11, 4).star(1, 4, 11).star(2, 11, 11).star(3, 18, 11).star(4, 11, 18).star(5, 6, 21).star(6, 16, 21).star(7, 5, 24).star(8, 17, 24).star(9, 4, 27).star(10, 18, 27).star(11, 8, 29).star(12, 14, 29).link(4, 12).link(12, 11).link(11, 4).link(5, 6).link(7, 8).link(9, 10).link(0, 3).link(3, 4).link(4, 1).link(1, 0).link(0, 2).link(2, 4).link(1, 2).link(2, 3).build()).build()).build()).style(StyleTemplate.builder().tooltip(TooltipData.builder().borderTop(-16729345).borderBottom(-16740183).textured(true).build()).build()).leveling(LevelingTemplate.builder().initialCost(100.0).step(200.0).build()).loot(LootTemplate.builder().entry(LootEntries.AQUATIC).build()).build();
    }

    public int getCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.JELLYFISH_NECKLACE_COOLDOWN, (Object)0);
    }

    public void setCooldown(ItemStack stack, int cooldown) {
        stack.set(RelicsDataComponents.JELLYFISH_NECKLACE_COOLDOWN, (Object)Math.max(0, cooldown));
    }

    public void addCooldown(ItemStack stack, int cooldown) {
        this.setCooldown(stack, this.getCooldown(stack) + cooldown);
    }

    public List<String> getDamagedEntities(ItemStack stack) {
        return new ArrayList<String>((Collection)stack.getOrDefault(RelicsDataComponents.JELLYFISH_NECKLACE_DAMAGED_ENTITIES, new ArrayList()));
    }

    public void setDamagedEntities(ItemStack stack, List<String> targets) {
        stack.set(RelicsDataComponents.JELLYFISH_NECKLACE_DAMAGED_ENTITIES, targets);
    }

    public void addDamagedEntities(ItemStack stack, String ... targets) {
        List<String> list = this.getDamagedEntities(stack);
        list.addAll(Lists.newArrayList((Object[])targets));
        this.setDamagedEntities(stack, list);
    }

    public void removeDamagedEntities(ItemStack stack, String ... targets) {
        List<String> list = this.getDamagedEntities(stack);
        list.removeAll(Lists.newArrayList((Object[])targets));
        this.setDamagedEntities(stack, list);
    }

    public int getDuration(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.JELLYFISH_NECKLACE_DURATION, (Object)0);
    }

    public void setDuration(ItemStack stack, int duration) {
        stack.set(RelicsDataComponents.JELLYFISH_NECKLACE_DURATION, (Object)Math.max(0, duration));
    }

    public void addDuration(ItemStack stack, int duration) {
        this.setDuration(stack, this.getDuration(stack) + duration);
    }

    public int getRings(ItemStack stack) {
        return (Integer)stack.getOrDefault(RelicsDataComponents.JELLYFISH_NECKLACE_RINGS, (Object)0);
    }

    public void setRings(ItemStack stack, int rings) {
        stack.set(RelicsDataComponents.JELLYFISH_NECKLACE_RINGS, (Object)Math.max(0, rings));
    }

    public void addRings(ItemStack stack, int rings) {
        this.setRings(stack, this.getRings(stack) + rings);
    }

    public List<String> getAffectedEntities(ItemStack stack) {
        return new ArrayList<String>((Collection)stack.getOrDefault(RelicsDataComponents.JELLYFISH_NECKLACE_AFFECTED_ENTITIES, new ArrayList()));
    }

    public void setAffectedEntities(ItemStack stack, List<String> targets) {
        stack.set(RelicsDataComponents.JELLYFISH_NECKLACE_AFFECTED_ENTITIES, targets);
    }

    public void addAffectedEntities(ItemStack stack, String ... targets) {
        List<String> list = this.getAffectedEntities(stack);
        list.addAll(Lists.newArrayList((Object[])targets));
        this.setAffectedEntities(stack, list);
    }

    public void removeAffectedEntities(ItemStack stack, String ... targets) {
        List<String> list = this.getAffectedEntities(stack);
        list.removeAll(Lists.newArrayList((Object[])targets));
        this.setAffectedEntities(stack, list);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.level();
        if (this.canPlayerUseAbility(entity, stack, "regeneration")) {
            float multiplier = (float)this.getStatValue(entity, stack, "regeneration", "max_health");
            if (entity.isInLiquid() || entity.isInRain()) {
                float boostedMaxHealth = entity.getMaxHealth() * multiplier;
                EntityUtils.resetAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_HEALTH, multiplier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
                EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_ABSORPTION, AttributeModifier.Operation.ADD_VALUE);
                entity.setHealth(entity.getHealth() + Math.min(entity.getAbsorptionAmount(), boostedMaxHealth));
            } else {
                EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
                if (this.isAbilityRankModifierUnlocked(entity, stack, "regeneration", "retention") && !EntityUtils.hasAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_HEALTH) && !EntityUtils.hasAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_ABSORPTION)) {
                    float baseMaxHealth = entity.getMaxHealth();
                    float currentHealth = entity.getHealth();
                    float extraHealth = Math.max(0.0f, currentHealth - baseMaxHealth);
                    entity.setHealth(Math.min(currentHealth, baseMaxHealth));
                    EntityUtils.resetAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_ABSORPTION, extraHealth, AttributeModifier.Operation.ADD_VALUE);
                    entity.setAbsorptionAmount(extraHealth);
                }
            }
        }
        if (this.canPlayerUseAbility(entity, stack, "shock") && !this.getAbilityMode(entity, stack, "shock").equals("disabled")) {
            int cooldown = this.getCooldown(stack);
            int rings = this.getRings(stack);
            if ((double)rings < this.getStatValue(entity, stack, "shock", "rings")) {
                int maxCooldown = (int)this.getStatValue(entity, stack, "shock", "cooldown");
                if (cooldown > 0) {
                    this.addCooldown(stack, -1);
                } else {
                    this.addRings(stack, 1);
                    this.setCooldown(stack, maxCooldown * 20);
                    if (!level.isClientSide()) {
                        this.addAbilityMetricValue(entity, stack, "shock", "rings_accumulated", 1.0);
                        this.addRelicExperience(entity, stack, "shock", "rings_accumulating", 1.0);
                    }
                }
            }
            List<String> affectedEntities = this.getAffectedEntities(stack);
            Predicate<LivingEntity> predicate = entry -> {
                String uuid = entry.getStringUUID();
                return !uuid.equals(entity.getStringUUID()) && !affectedEntities.contains(uuid);
            };
            List collidedEntities = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(0.5), predicate);
            if (rings > 0 && !collidedEntities.isEmpty()) {
                double radius = this.getStatValue(entity, stack, "shock", "radius");
                for (LivingEntity target : level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(0.5).inflate(radius), predicate)) {
                    Vec3 diff = target.position().add(0.0, (double)target.getBbHeight() / 2.0, 0.0).subtract(entity.position());
                    double knockback = 0.5 * this.getStatValue(entity, stack, "shock", "knockback");
                    double paralysis = this.getStatValue(entity, stack, "shock", "paralysis");
                    target.addEffect(new MobEffectInstance(RelicsMobEffects.PARALYSIS, (int)(paralysis * 20.0), 0, false, true));
                    if (!level.isClientSide()) {
                        this.addAbilityMetricValue(entity, stack, "shock", "rings_paralysis", paralysis);
                    }
                    target.setDeltaMovement(diff.normalize().multiply(knockback, knockback / 2.0, knockback));
                    ElectricSparkEntity spark = new ElectricSparkEntity((EntityType<? extends ElectricSparkEntity>)((EntityType)RelicsEntities.ELECTRIC_SPARK.get()), level);
                    spark.setDamageModifier(this.isAbilityRankModifierUnlocked(entity, stack, "shock", "conductor") ? (float)this.getStatValue(entity, stack, "shock", "damage_modifier") : 0.0f);
                    spark.setDistance((float)this.getStatValue(entity, stack, "shock", "distance"));
                    spark.setBounces((int)this.getStatValue(entity, stack, "shock", "bounces"));
                    spark.setDamage((float)this.getStatValue(entity, stack, "shock", "damage"));
                    spark.setPos(entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0));
                    spark.setFlawless(this.isRelicFlawless(entity, stack));
                    spark.setTarget(target);
                    spark.setOwner((Entity)entity);
                    spark.setStack(stack);
                    level.addFreshEntity((Entity)spark);
                    this.addAffectedEntities(stack, target.getStringUUID());
                    if (level.isClientSide()) continue;
                    this.addAbilityMetricValue(entity, stack, "shock", "arcs_spawned", 1.0);
                }
                this.addRings(stack, -1);
                if (this.isAbilityRankModifierUnlocked(entity, stack, "shock", "charge")) {
                    int maxDuration = (int)this.getStatValue(entity, stack, "shock", "duration");
                    this.setDuration(stack, maxDuration * 20);
                }
            }
            if (!affectedEntities.isEmpty()) {
                this.removeAffectedEntities(stack, (String[])affectedEntities.stream().filter(Predicate.not(collidedEntities.stream().map(Entity::getStringUUID).collect(Collectors.toSet())::contains)).toArray(String[]::new));
            }
            if (this.isAbilityRankModifierUnlocked(entity, stack, "shock", "charge")) {
                int duration = this.getDuration(stack);
                if (duration > 0) {
                    this.addDuration(stack, -1);
                } else {
                    this.setDamagedEntities(stack, new ArrayList<String>());
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_ABSORPTION, AttributeModifier.Operation.ADD_VALUE);
        EntityUtils.removeAttribute(entity, stack, (Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    @EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void onLivingHeal(LivingHealEvent event) {
            BlockPos max;
            LivingEntity entity = event.getEntity();
            Level level = entity.level();
            AABB box = entity.getBoundingBox();
            BlockPos min = BlockPos.containing((double)(Math.floor(box.minX) - 1.0), (double)Math.floor(box.minY), (double)(Math.floor(box.minZ) - 1.0));
            if (!level.hasChunksAt(min, max = BlockPos.containing((double)(Math.floor(box.maxX) + 1.0), (double)(Math.floor(entity.getEyeY()) + 1.0), (double)(Math.floor(box.maxZ) + 1.0)))) {
                return;
            }
            if (entity.isInLiquid() || entity.isInRain()) {
                for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity, (Item)RelicsItems.JELLYFISH_NECKLACE.get())) {
                    JellyfishNecklaceItem relic = (JellyfishNecklaceItem)stack.getItem();
                    if (!relic.canPlayerUseAbility(entity, stack, "regeneration")) continue;
                    double health = Math.min((double)entity.getMaxHealth(), (double)event.getAmount() * relic.getStatValue(entity, stack, "regeneration", "regeneration"));
                    event.setAmount((float)((double)event.getAmount() + health));
                    if (level.isClientSide()) continue;
                    relic.addAbilityMetricValue(entity, stack, "regeneration", "health_regenerated", health);
                    relic.addRelicExperience(entity, stack, "regeneration", "health_regeneration", health);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingDamageEvent.Pre event) {
            Entity entity = event.getSource().getDirectEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity2 = (LivingEntity)entity;
            Level level = entity2.level();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)entity2, (Item)RelicsItems.JELLYFISH_NECKLACE.get())) {
                LivingEntity target;
                String uuid;
                List<String> targets;
                int duration;
                JellyfishNecklaceItem relic = (JellyfishNecklaceItem)stack.getItem();
                if (!relic.canPlayerUseAbility(entity2, stack, "shock") || relic.getAbilityMode(entity2, stack, "shock").equals("disabled") || !relic.isAbilityRankModifierUnlocked(entity2, stack, "shock", "charge") || (duration = relic.getDuration(stack)) <= 0 || (targets = relic.getDamagedEntities(stack)).contains(uuid = (target = event.getEntity()).getStringUUID())) continue;
                double paralysis = relic.getStatValue(entity2, stack, "shock", "paralysis");
                target.addEffect(new MobEffectInstance(RelicsMobEffects.PARALYSIS, (int)(paralysis * 20.0), 0, false, false));
                if (!level.isClientSide()) {
                    relic.addAbilityMetricValue(entity2, stack, "shock", "hit_paralysis", paralysis);
                    relic.addRelicExperience(entity2, stack, "shock", "hit_paralysis", paralysis);
                }
                relic.addDamagedEntities(stack, uuid);
            }
        }
    }
}

