/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import it.hurts.sskirillss.relics.api.relics.AbilityMetricTemplate;
import it.hurts.sskirillss.relics.api.relics.AbilityStatisticTemplate;
import it.hurts.sskirillss.relics.api.relics.RelicTemplate;
import it.hurts.sskirillss.relics.api.relics.VisibilityState;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilitiesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.AbilityTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourceTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.ExperienceSourcesTemplate;
import it.hurts.sskirillss.relics.api.relics.abilities.stats.StatTemplate;
import it.hurts.sskirillss.relics.entities.ReflectiveOrbEntity;
import it.hurts.sskirillss.relics.init.RelicsEntities;
import it.hurts.sskirillss.relics.init.RelicsItems;
import it.hurts.sskirillss.relics.init.RelicsScalingModels;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleTemplate;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ServerScheduler;
import java.util.Comparator;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class ReflectiveNecklaceItem
extends RelicItem {
    public static final int ORB_SEARCH_RADIUS = 16;

    @Override
    public RelicTemplate constructDefaultRelicTemplate() {
        return RelicTemplate.builder().abilities(AbilitiesTemplate.builder().ability(AbilityTemplate.builder("reflection").initialMaxLevel(10).rankModifier(1, "stun").rankModifier(3, "piercing").rankModifier(5, "bounce").stat(StatTemplate.builder("chance").initialValue(0.1, 0.25).thresholdValue(0.0, 1.0).upgradeModifier(RelicsScalingModels.RADICAL.get(), 0.1268).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("damage").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.LOGARITHMIC.get(), 0.5581).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatTemplate.builder("lifetime").initialValue(5.0, 10.0).upgradeModifier(RelicsScalingModels.EXPONENTIAL.get(), 0.05255).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("piercings").initialValue(1.0, 3.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1619).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatTemplate.builder("stun").initialValue(0.25, 0.5).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.1143).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatTemplate.builder("bounces").initialValue(1.0, 2.0).upgradeModifier(RelicsScalingModels.MULTIPLICATIVE_BASE.get(), 0.6857).formatValue(value -> (int)MathUtils.round(value, 0)).build()).experienceSources(ExperienceSourcesTemplate.builder().source(ExperienceSourceTemplate.builder("construct").build()).source(ExperienceSourceTemplate.builder("impact").build()).build()).statistic(AbilityStatisticTemplate.builder().metric(AbilityMetricTemplate.builder("total_orbs").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).build()).metric(AbilityMetricTemplate.builder("total_damage").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).build()).metric(AbilityMetricTemplate.builder("total_stun").formatValue(value -> String.valueOf(MathUtils.round(value, 1))).rankModifierVisibilityState("stun", VisibilityState.OBFUSCATED).build()).metric(AbilityMetricTemplate.builder("total_bounces").formatValue(value -> String.valueOf((int)MathUtils.round(value, 0))).rankModifierVisibilityState("bounce", VisibilityState.OBFUSCATED).build()).build()).research(ResearchTemplate.builder().star(0, 17, 6).star(1, 4, 11).star(2, 16, 17).star(3, 9, 19).star(4, 18, 24).star(5, 4, 27).link(1, 3).link(3, 2).link(3, 4).link(0, 3).link(3, 5).build()).build()).build()).leveling(LevelingTemplate.builder().initialCost(100.0).step(200.0).build()).style(StyleTemplate.builder().tooltip(TooltipData.builder().borderTop(-16729345).borderBottom(-16740183).textured(true).build()).build()).loot(LootTemplate.builder().entry(LootEntries.NETHER_LIKE, LootEntries.THE_NETHER).build()).build();
    }

    @EventBusSubscriber(modid="relics")
    public static class CommonEvents {
        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent.Pre event) {
            Entity entity;
            Entity source = event.getSource().getEntity();
            float damage = event.getOriginalDamage();
            LivingEntity entity2 = event.getEntity();
            Level level = entity2.level();
            RandomSource random = level.getRandom();
            if (damage >= 1.0f) {
                for (ItemStack itemStack : EntityUtils.findEquippedCurios((Entity)entity2, (Item)RelicsItems.REFLECTIVE_NECKLACE.get())) {
                    ReflectiveNecklaceItem relic = (ReflectiveNecklaceItem)itemStack.getItem();
                    if (level.getRandom().nextDouble() > relic.getStatValue(entity2, itemStack, "reflection", "chance")) continue;
                    float orbDamage = Math.clamp((float)((double)damage * relic.getStatValue(entity2, itemStack, "reflection", "damage")), Float.MIN_VALUE, Float.MAX_VALUE);
                    ReflectiveOrbEntity orb2 = new ReflectiveOrbEntity((EntityType<? extends ThrowableProjectile>)((EntityType)RelicsEntities.REFLECTIVE_ORB.get()), level);
                    orb2.setPiercings(relic.isAbilityRankModifierUnlocked(entity2, itemStack, "reflection", "piercing") ? (int)relic.getStatValue(entity2, itemStack, "reflection", "piercings") : 0);
                    orb2.setBounces(relic.isAbilityRankModifierUnlocked(entity2, itemStack, "reflection", "bounce") ? (int)relic.getStatValue(entity2, itemStack, "reflection", "bounces") : 0);
                    orb2.setStun(relic.isAbilityRankModifierUnlocked(entity2, itemStack, "reflection", "stun") ? (float)((int)relic.getStatValue(entity2, itemStack, "reflection", "stun")) : 0.0f);
                    orb2.setLifetime((int)(relic.getStatValue(entity2, itemStack, "reflection", "lifetime") * 20.0));
                    orb2.setFlawless(relic.isRelicFlawless(entity2, itemStack));
                    orb2.setPos(entity2.getEyePosition());
                    orb2.setDamage(orbDamage);
                    orb2.setOwner((Entity)entity2);
                    orb2.setStack(itemStack);
                    if (source != null) {
                        orb2.setDeltaMovement(entity2.position().subtract(source.position()).normalize().add((double)MathUtils.randomFloat(random) * 0.5, 0.0, (double)MathUtils.randomFloat(random) * 0.5));
                    } else {
                        orb2.setDeltaMovement((double)MathUtils.randomFloat(random) * 0.5, 0.5 + (double)random.nextFloat() * 0.25, (double)MathUtils.randomFloat(random) * 0.5);
                    }
                    level.addFreshEntity((Entity)orb2);
                    relic.addRelicExperience(entity2, itemStack, "reflection", "construct", (double)orbDamage * 0.1);
                    relic.addAbilityMetricValue(entity2, itemStack, "reflection", "total_orbs", 1.0);
                }
            }
            if (!((entity = event.getSource().getEntity()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingSource = (LivingEntity)entity;
            ItemStack itemStack = EntityUtils.findEquippedCurio((Entity)livingSource, (Item)RelicsItems.REFLECTIVE_NECKLACE.get());
            if (!itemStack.isEmpty()) {
                int step = 0;
                for (ReflectiveOrbEntity orb2 : level.getEntitiesOfClass(ReflectiveOrbEntity.class, livingSource.getBoundingBox().inflate(16.0)).stream().filter(orb -> {
                    LivingEntity owner;
                    Entity patt0$temp;
                    return !orb.isTargeted() && (patt0$temp = orb.getOwner()) instanceof LivingEntity && (owner = (LivingEntity)patt0$temp).getStringUUID().equals(livingSource.getStringUUID());
                }).sorted(Comparator.comparingInt(orb -> (int)orb.position().distanceTo(entity2.position()))).toList()) {
                    ServerScheduler.schedule(step++ * 2, () -> orb2.setTarget(entity2.position().add(0.0, (double)entity2.getBbHeight(), 0.0).add(entity2.getKnownMovement())));
                }
            }
        }
    }
}

