/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.api.events.common.EntityBlockSpeedFactorEvent;
import it.hurts.sskirillss.relics.api.events.common.FluidCollisionEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @ModifyVariable(method={"move"}, ordinal=1, index=3, name={"vec32"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    public Vec3 fluidCollision(Vec3 original) {
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity)) {
            return original;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (original.y > 0.0) {
            return original;
        }
        Level level = entity2.getCommandSenderWorld();
        int[][] offsets = new int[][]{{1, 0, 1}, {1, 0, 0}, {1, -1, 0}, {1, 0, -1}, {0, 0, 1}, {0, 0, 0}, {0, -1, 0}, {0, 0, -1}, {-1, 0, 1}, {-1, 0, 0}, {-1, -1, 0}, {-1, 0, -1}};
        double highestValue = original.y;
        FluidState highestFluid = null;
        for (int[] offset : offsets) {
            double height;
            VoxelShape shape;
            BlockPos sourcePos = entity2.blockPosition();
            BlockPos pos = new BlockPos(sourcePos.getX() + offset[0], sourcePos.getY() + offset[1], sourcePos.getZ() + offset[2]);
            FluidState fluidState = level.getFluidState(pos);
            if (fluidState.isEmpty() || !Shapes.joinIsNotEmpty((VoxelShape)(shape = Shapes.block().move((double)pos.getX(), (double)((float)pos.getY() + fluidState.getOwnHeight()), (double)pos.getZ())), (VoxelShape)Shapes.create((AABB)entity2.getBoundingBox().inflate(0.5)), (BooleanOp)BooleanOp.AND) || !(highestValue < (height = shape.max(Direction.Axis.Y) - entity2.getY() - 1.0))) continue;
            highestValue = height;
            highestFluid = fluidState;
        }
        if (highestFluid == null) {
            return original;
        }
        FluidCollisionEvent event = new FluidCollisionEvent(entity2, highestFluid);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            entity2.fallDistance = 0.0f;
            entity2.setOnGround(true);
            return new Vec3(original.x, highestValue, original.z);
        }
        return original;
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="RETURN")}, cancellable=true)
    public void getBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        Entity entity = (Entity)this;
        EntityBlockSpeedFactorEvent event = new EntityBlockSpeedFactorEvent(entity, entity.level().getBlockState(entity.getOnPos()), ((Float)cir.getReturnValue()).floatValue());
        NeoForge.EVENT_BUS.post((Event)event);
        cir.setReturnValue((Object)Float.valueOf(event.getSpeedFactor()));
    }
}

