/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketSyncEntityEffects
implements CustomPacketPayload {
    private final CompoundTag data;
    private final Action action;
    private final int entity;
    public static final CustomPacketPayload.Type<PacketSyncEntityEffects> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"sync_entity_effect"));
    public static final StreamCodec<ByteBuf, PacketSyncEntityEffects> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, PacketSyncEntityEffects::getData, (StreamCodec)ByteBufCodecs.idMapper(Action.BY_ID, Action::getId), PacketSyncEntityEffects::getAction, (StreamCodec)ByteBufCodecs.INT, PacketSyncEntityEffects::getEntity, PacketSyncEntityEffects::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Entity patt0$temp;
            Minecraft MC = Minecraft.getInstance();
            ClientLevel level = MC.level;
            if (level == null || !((patt0$temp = level.getEntity(this.entity)) instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)patt0$temp;
            MobEffectInstance effect = MobEffectInstance.load((CompoundTag)this.data);
            if (effect != null) {
                switch (this.action.ordinal()) {
                    case 0: 
                    case 2: {
                        entity.addEffect(effect);
                        break;
                    }
                    case 1: {
                        entity.removeEffect(effect.getEffect());
                    }
                }
            }
        });
    }

    @Generated
    public CompoundTag getData() {
        return this.data;
    }

    @Generated
    public Action getAction() {
        return this.action;
    }

    @Generated
    public int getEntity() {
        return this.entity;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketSyncEntityEffects)) {
            return false;
        }
        PacketSyncEntityEffects other = (PacketSyncEntityEffects)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntity() != other.getEntity()) {
            return false;
        }
        CompoundTag this$data = this.getData();
        CompoundTag other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        return !(this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PacketSyncEntityEffects;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntity();
        CompoundTag $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PacketSyncEntityEffects(data=" + String.valueOf(this.getData()) + ", action=" + String.valueOf((Object)this.getAction()) + ", entity=" + this.getEntity() + ")";
    }

    @Generated
    public PacketSyncEntityEffects(CompoundTag data, Action action, int entity) {
        this.data = data;
        this.action = action;
        this.entity = entity;
    }

    public static enum Action {
        ADD(0),
        REMOVE(1),
        UPDATE(2);

        public static final IntFunction<Action> BY_ID;
        private final int id;

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        private Action(int id) {
            this.id = id;
        }

        static {
            BY_ID = ByIdMap.continuous(Action::getId, (Object[])Action.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

