/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.description.ability;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.api.events.leveling.AbilityModeSwitchEvent;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.network.packets.description.IRelicValidator;
import lombok.Generated;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class C2SChangeMode
implements CustomPacketPayload,
IRelicValidator {
    private final int container;
    private final int slot;
    private final String ability;
    private final String mode;
    public static final CustomPacketPayload.Type<C2SChangeMode> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"description/ability/change_mode"));
    public static final StreamCodec<ByteBuf, C2SChangeMode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, C2SChangeMode::getContainer, (StreamCodec)ByteBufCodecs.INT, C2SChangeMode::getSlot, (StreamCodec)ByteBufCodecs.STRING_UTF8, C2SChangeMode::getAbility, (StreamCodec)ByteBufCodecs.STRING_UTF8, C2SChangeMode::getMode, C2SChangeMode::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player.containerMenu.containerId != this.getContainer()) {
                this.causeError(player);
                return;
            }
            ItemStack stack = DescriptionUtils.gatherRelicStack(player, this.getSlot());
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                this.causeError(player);
                return;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            AbilityModeSwitchEvent event = new AbilityModeSwitchEvent((LivingEntity)player, stack, this.getAbility(), relic.getAbilityMode((LivingEntity)player, stack, this.getAbility()), this.getMode());
            NeoForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                relic.setAbilityMode(event.getEntity(), event.getStack(), event.getAbility(), event.getToMode());
            }
            try {
                player.containerMenu.getSlot(this.getSlot()).set(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.causeError(player);
            }
        });
    }

    @Generated
    public int getContainer() {
        return this.container;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public String getAbility() {
        return this.ability;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof C2SChangeMode)) {
            return false;
        }
        C2SChangeMode other = (C2SChangeMode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainer() != other.getContainer()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        String this$ability = this.getAbility();
        String other$ability = other.getAbility();
        if (this$ability == null ? other$ability != null : !this$ability.equals(other$ability)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof C2SChangeMode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainer();
        result = result * 59 + this.getSlot();
        String $ability = this.getAbility();
        result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "C2SChangeMode(container=" + this.getContainer() + ", slot=" + this.getSlot() + ", ability=" + this.getAbility() + ", mode=" + this.getMode() + ")";
    }

    @Generated
    public C2SChangeMode(int container, int slot, String ability, String mode) {
        this.container = container;
        this.slot = slot;
        this.ability = ability;
        this.mode = mode;
    }
}

