/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.description.ability;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.network.packets.description.IRelicValidator;
import lombok.Generated;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class C2SPacketAbilityUnlock
implements CustomPacketPayload,
IRelicValidator {
    private final int container;
    private final int slot;
    private final String ability;
    private final int unlocks;
    public static final CustomPacketPayload.Type<C2SPacketAbilityUnlock> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"ability_unlock"));
    public static final StreamCodec<ByteBuf, C2SPacketAbilityUnlock> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, C2SPacketAbilityUnlock::getContainer, (StreamCodec)ByteBufCodecs.INT, C2SPacketAbilityUnlock::getSlot, (StreamCodec)ByteBufCodecs.STRING_UTF8, C2SPacketAbilityUnlock::getAbility, (StreamCodec)ByteBufCodecs.INT, C2SPacketAbilityUnlock::getUnlocks, C2SPacketAbilityUnlock::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player.containerMenu.containerId != this.container) {
                this.causeError(player);
                return;
            }
            ItemStack stack = DescriptionUtils.gatherRelicStack(player, this.slot);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                this.causeError(player);
                return;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            relic.setLockUnlocks((LivingEntity)player, stack, this.ability, this.unlocks);
            try {
                player.containerMenu.getSlot(this.slot).set(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.causeError(player);
            }
        });
    }

    @Generated
    public int getContainer() {
        return this.container;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public String getAbility() {
        return this.ability;
    }

    @Generated
    public int getUnlocks() {
        return this.unlocks;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof C2SPacketAbilityUnlock)) {
            return false;
        }
        C2SPacketAbilityUnlock other = (C2SPacketAbilityUnlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainer() != other.getContainer()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.getUnlocks() != other.getUnlocks()) {
            return false;
        }
        String this$ability = this.getAbility();
        String other$ability = other.getAbility();
        return !(this$ability == null ? other$ability != null : !this$ability.equals(other$ability));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof C2SPacketAbilityUnlock;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainer();
        result = result * 59 + this.getSlot();
        result = result * 59 + this.getUnlocks();
        String $ability = this.getAbility();
        result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "C2SPacketAbilityUnlock(container=" + this.getContainer() + ", slot=" + this.getSlot() + ", ability=" + this.getAbility() + ", unlocks=" + this.getUnlocks() + ")";
    }

    @Generated
    public C2SPacketAbilityUnlock(int container, int slot, String ability, int unlocks) {
        this.container = container;
        this.slot = slot;
        this.ability = ability;
        this.unlocks = unlocks;
    }
}

