/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.item.springy_boot;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.utils.MathUtils;
import lombok.Generated;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.joml.Vector3f;

public class S2CBounceFromSurface
implements CustomPacketPayload {
    private final int id;
    private final Vector3f motion;
    public static final CustomPacketPayload.Type<S2CBounceFromSurface> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"springy_boot/bounce_from_surface"));
    public static final StreamCodec<ByteBuf, S2CBounceFromSurface> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, S2CBounceFromSurface::getId, (StreamCodec)ByteBufCodecs.VECTOR3F, S2CBounceFromSurface::getMotion, S2CBounceFromSurface::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            Level level = player.level();
            RandomSource random = level.getRandom();
            Entity entity = level.getEntity(this.getId());
            if (entity == null) {
                return;
            }
            Vec3 motion = new Vec3(this.getMotion());
            double speed = Math.abs(motion.y());
            entity.setDeltaMovement(motion);
            float i = 0.0f;
            while ((double)i < speed * 5.0) {
                double angle = (double)random.nextFloat() * Math.PI * 2.0;
                double radius = Math.sqrt(random.nextFloat()) * speed * (double)0.15f;
                double dx = Math.cos(angle) * radius;
                double dz = Math.sin(angle) * radius;
                level.addParticle((ParticleOptions)ParticleTypes.CLOUD, entity.getX(), entity.getY(), entity.getZ(), dx, (double)(random.nextFloat() * 0.15f), dz);
                i += 0.1f;
            }
            int i2 = 0;
            while ((double)i2 < 50.0 * speed) {
                Vec3 particleMotion = motion.normalize().scale((double)random.nextFloat());
                level.addParticle((ParticleOptions)ParticleTypes.CLOUD, entity.getX() + (double)(MathUtils.randomFloat(random) * 0.5f), entity.getY(), entity.getZ() + (double)(MathUtils.randomFloat(random) * 0.5f), particleMotion.x(), particleMotion.y(), particleMotion.z());
                ++i2;
            }
        });
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public Vector3f getMotion() {
        return this.motion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S2CBounceFromSurface)) {
            return false;
        }
        S2CBounceFromSurface other = (S2CBounceFromSurface)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Vector3f this$motion = this.getMotion();
        Vector3f other$motion = other.getMotion();
        return !(this$motion == null ? other$motion != null : !this$motion.equals(other$motion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof S2CBounceFromSurface;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        Vector3f $motion = this.getMotion();
        result = result * 59 + ($motion == null ? 43 : $motion.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "S2CBounceFromSurface(id=" + this.getId() + ", motion=" + String.valueOf(this.getMotion()) + ")";
    }

    @Generated
    public S2CBounceFromSurface(int id, Vector3f motion) {
        this.id = id;
        this.motion = motion;
    }
}

