/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import java.util.function.IntFunction;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketRelicTweak
implements CustomPacketPayload {
    private final int container;
    private final int slot;
    private final Operation operation;
    private final boolean withShift;
    public static final CustomPacketPayload.Type<PacketRelicTweak> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"ability_tweak"));
    public static final StreamCodec<ByteBuf, PacketRelicTweak> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketRelicTweak::getContainer, (StreamCodec)ByteBufCodecs.INT, PacketRelicTweak::getSlot, (StreamCodec)ByteBufCodecs.idMapper(Operation.BY_ID, Operation::getId), PacketRelicTweak::getOperation, (StreamCodec)ByteBufCodecs.BOOL, PacketRelicTweak::isWithShift, PacketRelicTweak::new);

    public PacketRelicTweak(int container, int slot, String ability, Operation operation) {
        this(container, slot, operation, false);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player.containerMenu.containerId != this.container) {
                PacketRelicTweak.causeError(player);
                return;
            }
            ItemStack stack = DescriptionUtils.gatherRelicStack(player, this.slot);
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof IRelicItem)) {
                PacketRelicTweak.causeError(player);
                return;
            }
            IRelicItem relic = (IRelicItem)patt0$temp;
            switch (this.operation.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            if (!relic.rankup(player, stack)) {
                return;
            }
            try {
                player.containerMenu.getSlot(this.slot).set(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                PacketRelicTweak.causeError(player);
            }
        });
    }

    private static void causeError(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"info.relics.researching.wrong_container").withStyle(ChatFormatting.RED), false);
        player.closeContainer();
    }

    @Generated
    public int getContainer() {
        return this.container;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public Operation getOperation() {
        return this.operation;
    }

    @Generated
    public boolean isWithShift() {
        return this.withShift;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketRelicTweak)) {
            return false;
        }
        PacketRelicTweak other = (PacketRelicTweak)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainer() != other.getContainer()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.isWithShift() != other.isWithShift()) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PacketRelicTweak;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainer();
        result = result * 59 + this.getSlot();
        result = result * 59 + (this.isWithShift() ? 79 : 97);
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PacketRelicTweak(container=" + this.getContainer() + ", slot=" + this.getSlot() + ", operation=" + String.valueOf((Object)this.getOperation()) + ", withShift=" + this.isWithShift() + ")";
    }

    @Generated
    public PacketRelicTweak(int container, int slot, Operation operation, boolean withShift) {
        this.container = container;
        this.slot = slot;
        this.operation = operation;
        this.withShift = withShift;
    }

    public static enum Operation {
        RANKUP(0);

        public static final IntFunction<Operation> BY_ID;
        private final int id;

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        private Operation(int id) {
            this.id = id;
        }

        static {
            BY_ID = ByIdMap.continuous(Operation::getId, (Object[])Operation.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

