/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import java.awt.Color;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FlawlessUtils {
    public static Color getColor(LivingEntity entity, ItemStack stack, Color color) {
        IRelicItem relic;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).isRelicFlawless(entity, stack)) {
            return color;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float goldenHue = 0.125f;
        float saturation = Math.min(1.0f, hsb[1] * 0.8f + 0.2f);
        float brightness = Math.min(1.0f, hsb[2] * 0.9f + 0.1f);
        return Color.getHSBColor(goldenHue, saturation, brightness);
    }

    public static ResourceLocation getTexture(LivingEntity entity, ItemStack stack, ResourceLocation location) {
        boolean isFlawless = ((IRelicItem)stack.getItem()).isRelicFlawless(entity, stack);
        return isFlawless ? ResourceLocation.parse((String)location.toString().replaceFirst("\\.png$", "_flawless.png")) : location;
    }
}

