/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils.data;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import it.hurts.sskirillss.relics.utils.data.SpriteMirror;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class GUIRenderer {
    private static final GUIRenderer INSTANCE = new GUIRenderer();
    private ResourceLocation texture;
    private PoseStack pose;
    private float posX;
    private float posY;
    private int texWidth;
    private int texHeight;
    private int patternWidth;
    private int patternHeight;
    private int texOffX;
    private int texOffY;
    private float scale;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private Supplier<Long> time;
    private AnimationData animation;
    private SpriteAnchor anchor;
    private List<SpriteMirror> mirror;

    public static GUIRenderer begin(ResourceLocation texture, PoseStack pose) {
        GUIRenderer renderer = INSTANCE;
        renderer.texture = texture;
        renderer.pose = pose;
        renderer.posX = 0.0f;
        renderer.posY = 0.0f;
        renderer.texWidth = -1;
        renderer.texHeight = -1;
        renderer.patternWidth = -1;
        renderer.patternHeight = -1;
        renderer.texOffX = 0;
        renderer.texOffY = 0;
        renderer.scale = 1.0f;
        renderer.red = -1.0f;
        renderer.green = -1.0f;
        renderer.blue = -1.0f;
        renderer.alpha = -1.0f;
        renderer.time = () -> {
            ClientLevel level = Minecraft.getInstance().level;
            return level == null ? 0L : level.getGameTime();
        };
        renderer.animation = AnimationData.builder().frame(0, Integer.MAX_VALUE);
        renderer.anchor = SpriteAnchor.CENTER;
        renderer.mirror = new ArrayList<SpriteMirror>();
        return renderer;
    }

    public GUIRenderer pos(float posX, float posY) {
        GUIRenderer renderer = INSTANCE;
        renderer.posX = posX;
        renderer.posY = posY;
        return renderer;
    }

    public GUIRenderer texSize(int texWidth, int texHeight) {
        GUIRenderer renderer = INSTANCE;
        renderer.texWidth = texWidth;
        renderer.texHeight = texHeight;
        return renderer;
    }

    public GUIRenderer patternSize(int patternWidth, int patternHeight) {
        GUIRenderer renderer = INSTANCE;
        renderer.patternWidth = patternWidth;
        renderer.patternHeight = patternHeight;
        return renderer;
    }

    public GUIRenderer texOff(int texOffX, int texOffY) {
        GUIRenderer renderer = INSTANCE;
        renderer.texOffX = texOffX;
        renderer.texOffY = texOffY;
        return renderer;
    }

    public GUIRenderer color(float red, float green, float blue, float alpha) {
        GUIRenderer renderer = INSTANCE;
        renderer.red = red;
        renderer.green = green;
        renderer.blue = blue;
        renderer.alpha = alpha;
        return renderer;
    }

    public GUIRenderer color(int red, int green, int blue, int alpha) {
        return this.color((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public GUIRenderer color(Color color) {
        return this.color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public GUIRenderer color(int color) {
        return this.color(new Color(color));
    }

    public GUIRenderer mirror(SpriteMirror ... mirror) {
        GUIRenderer renderer = INSTANCE;
        renderer.mirror.addAll(Arrays.asList(mirror));
        return renderer;
    }

    public void end() {
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Minecraft.getInstance().getTextureManager().getTexture(this.texture).bind();
        float[] color = Arrays.copyOf(RenderSystem.getShaderColor(), RenderSystem.getShaderColor().length);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.setShaderColor((float)(this.red == -1.0f ? color[0] : this.red), (float)(this.green == -1.0f ? color[1] : this.green), (float)(this.blue == -1.0f ? color[2] : this.blue), (float)(this.alpha == -1.0f ? color[3] : this.alpha));
        RenderSystem.disableCull();
        if (this.texHeight == -1) {
            this.texHeight = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        }
        if (this.texWidth == -1) {
            this.texWidth = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        }
        if (this.patternHeight == -1) {
            this.patternHeight = this.texHeight;
        }
        if (this.patternWidth == -1) {
            this.patternWidth = this.texWidth;
        }
        this.texOffY += this.patternHeight * (Integer)this.animation.getFrameByTime(this.time.get()).getKey();
        this.pose.pushPose();
        float xOff = this.anchor.getXOffset(this.patternWidth, this.scale);
        float yOff = this.anchor.getYOffset(this.patternHeight, this.scale);
        this.pose.translate(this.posX - xOff, this.posY - yOff, 0.0f);
        this.pose.scale(this.scale, this.scale, 0.0f);
        Matrix4f m = this.pose.last().pose();
        float u1 = (float)this.texOffX / (float)this.texWidth;
        float u2 = (float)(this.texOffX + this.patternWidth) / (float)this.texWidth;
        float v1 = (float)(this.texOffY + this.patternHeight) / (float)this.texHeight;
        float v2 = (float)this.texOffY / (float)this.texHeight;
        for (SpriteMirror mirror : this.mirror) {
            switch (mirror) {
                case HORIZONTAL: {
                    float f = u1 + u2;
                    u2 = u1;
                    u1 = f - u2;
                    break;
                }
                case VERTICAL: {
                    float f = v1 + v2;
                    v2 = v1;
                    v1 = f - v2;
                }
            }
        }
        builder.addVertex(m, 0.0f, (float)this.patternHeight, 0.0f).setUv(u1, v1);
        builder.addVertex(m, (float)this.patternWidth, (float)this.patternHeight, 0.0f).setUv(u2, v1);
        builder.addVertex(m, (float)this.patternWidth, 0.0f, 0.0f).setUv(u2, v2);
        builder.addVertex(m, 0.0f, 0.0f, 0.0f).setUv(u1, v2);
        this.pose.popPose();
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.enableCull();
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
    }

    @Generated
    public GUIRenderer posX(float posX) {
        this.posX = posX;
        return this;
    }

    @Generated
    public GUIRenderer posY(float posY) {
        this.posY = posY;
        return this;
    }

    @Generated
    public GUIRenderer texWidth(int texWidth) {
        this.texWidth = texWidth;
        return this;
    }

    @Generated
    public GUIRenderer texHeight(int texHeight) {
        this.texHeight = texHeight;
        return this;
    }

    @Generated
    public GUIRenderer patternWidth(int patternWidth) {
        this.patternWidth = patternWidth;
        return this;
    }

    @Generated
    public GUIRenderer patternHeight(int patternHeight) {
        this.patternHeight = patternHeight;
        return this;
    }

    @Generated
    public GUIRenderer texOffX(int texOffX) {
        this.texOffX = texOffX;
        return this;
    }

    @Generated
    public GUIRenderer texOffY(int texOffY) {
        this.texOffY = texOffY;
        return this;
    }

    @Generated
    public GUIRenderer scale(float scale) {
        this.scale = scale;
        return this;
    }

    @Generated
    public GUIRenderer red(float red) {
        this.red = red;
        return this;
    }

    @Generated
    public GUIRenderer green(float green) {
        this.green = green;
        return this;
    }

    @Generated
    public GUIRenderer blue(float blue) {
        this.blue = blue;
        return this;
    }

    @Generated
    public GUIRenderer alpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    @Generated
    public GUIRenderer time(Supplier<Long> time) {
        this.time = time;
        return this;
    }

    @Generated
    public GUIRenderer animation(AnimationData animation) {
        this.animation = animation;
        return this;
    }

    @Generated
    public GUIRenderer anchor(SpriteAnchor anchor) {
        this.anchor = anchor;
        return this;
    }

    @Generated
    public GUIRenderer() {
    }
}

