/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.virentia.fluid;

import net.mcreator.virentia.init.VirentiaModBlocks;
import net.mcreator.virentia.init.VirentiaModFluidTypes;
import net.mcreator.virentia.init.VirentiaModFluids;
import net.mcreator.virentia.init.VirentiaModItems;
import net.mcreator.virentia.init.VirentiaModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class RedwaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)VirentiaModFluidTypes.REDWATER_TYPE.get(), () -> (Fluid)VirentiaModFluids.REDWATER.get(), () -> (Fluid)VirentiaModFluids.FLOWING_REDWATER.get()).explosionResistance(100.0f).tickRate(10).bucket(() -> (Item)VirentiaModItems.REDWATER_BUCKET.get()).block(() -> (LiquidBlock)VirentiaModBlocks.REDWATER.get());

    private RedwaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return (SimpleParticleType)VirentiaModParticleTypes.REDWATER_DRIP.get();
    }

    public static class Flowing
    extends RedwaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends RedwaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

