/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.OptionalInt;
import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.data.TradeTable;
import me.drex.villagerconfig.common.mixin.VillagerAccessor;
import me.drex.villagerconfig.common.util.TestMerchantMenu;
import me.drex.villagerconfig.common.util.TradeProvider;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;

public class TestCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> builder(CommandBuildContext commandBuildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"test").then(Commands.literal((String)"villager").then(((RequiredArgumentBuilder)Commands.argument((String)"profession", (ArgumentType)ResourceArgument.resource((CommandBuildContext)commandBuildContext, (ResourceKey)Registries.VILLAGER_PROFESSION)).executes(context -> TestCommand.testVillager((CommandSourceStack)context.getSource(), (Holder.Reference<VillagerProfession>)ResourceArgument.getResource((CommandContext)context, (String)"profession", (ResourceKey)Registries.VILLAGER_PROFESSION), -1))).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TestCommand.testVillager((CommandSourceStack)context.getSource(), (Holder.Reference<VillagerProfession>)ResourceArgument.getResource((CommandContext)context, (String)"profession", (ResourceKey)Registries.VILLAGER_PROFESSION), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))).then(Commands.literal((String)TradeProvider.WANDERING_TRADER_ID.getPath()).executes(context -> TestCommand.testWanderingTrader((CommandSourceStack)context.getSource())));
    }

    private static int testVillager(CommandSourceStack source, Holder.Reference<VillagerProfession> professionHolder, int level) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        Villager fakeVillager = (Villager)EntityType.VILLAGER.create((Level)source.getLevel(), EntitySpawnReason.COMMAND);
        assert (fakeVillager != null);
        fakeVillager.setPos(player.position());
        VillagerData villagerData = new VillagerData(VillagerType.PLAINS, (VillagerProfession)professionHolder.value(), 1);
        fakeVillager.setVillagerData(villagerData);
        if (level < 0) {
            TradeTable tradeTable = VillagerConfig.TRADE_MANAGER.getTrade(professionHolder.key().location());
            level = tradeTable != null ? tradeTable.maxLevel() : 5;
        }
        fakeVillager.getOffers();
        for (int i = 0; i < level - 1; ++i) {
            ((VillagerAccessor)fakeVillager).invokeIncreaseMerchantCareer();
        }
        TestCommand.openMenu((AbstractVillager)fakeVillager, fakeVillager.getVillagerData().getLevel(), player);
        return 1;
    }

    private static int testWanderingTrader(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        WanderingTrader fakeTrader = (WanderingTrader)EntityType.WANDERING_TRADER.create((Level)source.getLevel(), EntitySpawnReason.COMMAND);
        fakeTrader.setPos(player.position());
        fakeTrader.getOffers();
        TestCommand.openMenu((AbstractVillager)fakeTrader, 1, player);
        return 1;
    }

    private static void openMenu(AbstractVillager villager, int level, ServerPlayer player) {
        MerchantOffers merchantOffers;
        OptionalInt optionalInt = player.openMenu((MenuProvider)new SimpleMenuProvider((ix, inventory, playerx) -> new TestMerchantMenu(ix, inventory, (Merchant)villager), villager.getDisplayName()));
        if (optionalInt.isPresent() && !(merchantOffers = villager.getOffers()).isEmpty()) {
            player.sendMerchantOffers(optionalInt.getAsInt(), merchantOffers, level, villager.getVillagerXp(), villager.showProgressBar(), villager.canRestock());
        }
    }
}

