/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import me.drex.villagerconfig.common.config.ConfigManager;
import me.drex.villagerconfig.common.util.interfaces.IVillager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractVillager.class})
public abstract class AbstractVillagerMixin
extends AgeableMob
implements IVillager,
Merchant {
    private RandomSource semiRandom;

    @Shadow
    @NotNull
    public abstract MerchantOffers getOffers();

    @Shadow
    public abstract int getVillagerXp();

    @Shadow
    public abstract boolean showProgressBar();

    @Shadow
    @Nullable
    public abstract Player getTradingPlayer();

    protected AbstractVillagerMixin(EntityType<? extends AgeableMob> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"addOffersFromItemListings"}, at={@At(value="HEAD")})
    public void generateRandom(MerchantOffers recipeList, VillagerTrades.ItemListing[] pool, int count, CallbackInfo ci) {
        if (ConfigManager.CONFIG.features.tradeCycling) {
            return;
        }
        long seed = this.uuid.getLeastSignificantBits();
        AbstractVillagerMixin abstractVillagerMixin = this;
        if (abstractVillagerMixin instanceof Villager) {
            Villager villager = (Villager)abstractVillagerMixin;
            int level = villager.getVillagerData().getLevel();
            seed += (long)level;
        }
        this.semiRandom = RandomSource.create((long)seed);
    }

    @WrapOperation(method={"addOffersFromItemListings"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/world/entity/npc/AbstractVillager;random:Lnet/minecraft/util/RandomSource;")})
    public RandomSource replaceRandom(AbstractVillager merchantEntity, Operation<RandomSource> original) {
        return ConfigManager.CONFIG.features.tradeCycling ? (RandomSource)original.call(new Object[]{merchantEntity}) : this.semiRandom;
    }
}

