/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.mixin;

import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.data.TradeTable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Shadow
    public abstract VillagerData getVillagerData();

    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"updateTrades"}, at={@At(value="HEAD")}, cancellable=true)
    public void putCustomTrades(CallbackInfo ci) {
        TradeTable tradeTable = this.getTradeTable();
        if (tradeTable != null) {
            VillagerData villagerData = this.getVillagerData();
            int level = villagerData.getLevel();
            VillagerTrades.ItemListing[] customOffers = tradeTable.getTradeOffers(this, level);
            this.addOffersFromItemListings(this.getOffers(), customOffers, customOffers.length);
            ci.cancel();
        }
    }

    @Redirect(method={"shouldIncreaseLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/VillagerData;canLevelUp(I)Z"))
    public boolean adjustMaxLevel(int level) {
        return this.customCanLevelUp(level);
    }

    @Redirect(method={"shouldIncreaseLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/VillagerData;getMaxXpPerLevel(I)I"))
    public int adjustUpperLevelExperience(int level) {
        return this.customUpperLevelExperience(level);
    }

    private int customUpperLevelExperience(int level) {
        TradeTable tradeTable;
        if (this.customCanLevelUp(level) && (tradeTable = this.getTradeTable()) != null) {
            return tradeTable.requiredExperience(level + 1);
        }
        return VillagerData.getMaxXpPerLevel((int)level);
    }

    private boolean customCanLevelUp(int level) {
        TradeTable tradeTable = this.getTradeTable();
        if (tradeTable != null) {
            int maxLevel = tradeTable.maxLevel();
            return level >= 1 && level < maxLevel;
        }
        return VillagerData.canLevelUp((int)level);
    }

    private TradeTable getTradeTable() {
        if (this.level() instanceof ServerLevel) {
            ResourceLocation identifier = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)this.getVillagerData().getProfession());
            return VillagerConfig.TRADE_MANAGER.getTrade(identifier);
        }
        return null;
    }
}

