/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.mixin;

import me.drex.villagerconfig.common.config.ConfigManager;
import me.drex.villagerconfig.common.util.RandomUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Zombie.class})
public abstract class ZombieMixin
extends Monster {
    private Difficulty difficulty = Difficulty.PEACEFUL;

    protected ZombieMixin(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"killedEntity"}, at={@At(value="HEAD")})
    public void calculateConversionChance(ServerLevel serverLevel, LivingEntity livingEntity, CallbackInfoReturnable<Boolean> cir) {
        double conversionChance = ConfigManager.CONFIG.features.conversionChance;
        this.difficulty = conversionChance < 0.0 ? this.level().getDifficulty() : (!RandomUtil.chance(conversionChance) ? Difficulty.EASY : Difficulty.HARD);
    }

    @Redirect(method={"killedEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getDifficulty()Lnet/minecraft/world/Difficulty;"), require=0)
    public Difficulty shouldConvert(ServerLevel serverLevel) {
        return this.difficulty;
    }
}

