/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.data.TradeTable;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TradeManager
extends SimpleJsonResourceReloadListener<TradeTable> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"villagerconfig", (String)"trades");
    private static final Logger LOGGER = VillagerConfig.LOGGER;
    private Map<ResourceLocation, TradeTable> trades = ImmutableMap.of();

    public TradeManager(HolderLookup.Provider provider) {
        super((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), TradeTable.CODEC, FileToIdConverter.json((String)"trades"));
    }

    @Nullable
    public TradeTable getTrade(ResourceLocation id) {
        return this.trades.get(id);
    }

    protected void apply(Map<ResourceLocation, TradeTable> prepared, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.trades = prepared;
        LOGGER.info("Loaded {} trades", (Object)this.trades.size());
    }
}

