/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util.loot.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import me.drex.villagerconfig.common.util.loot.LootNumberProviderTypes;
import me.drex.villagerconfig.common.util.loot.VCLootContextParams;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public record ReferenceLootNumberProvider(String id) implements NumberProvider
{
    public static final MapCodec<ReferenceLootNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(ReferenceLootNumberProvider::id)).apply((Applicative)instance, ReferenceLootNumberProvider::new));

    public float getFloat(LootContext context) {
        if (!context.hasParameter(VCLootContextParams.NUMBER_REFERENCE)) {
            return 0.0f;
        }
        return ((Map)context.getParameter(VCLootContextParams.NUMBER_REFERENCE)).getOrDefault(this.id, Float.valueOf(0.0f)).floatValue();
    }

    @NotNull
    public LootNumberProviderType getType() {
        return LootNumberProviderTypes.REFERENCE;
    }

    public static ReferenceLootNumberProvider create(String id) {
        return new ReferenceLootNumberProvider(id);
    }
}

