/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type.PlainSerializableType;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.serialization.TypeSerializer;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.impl.fiber.constraint.StringConstraintChecker;

public final class StringSerializableType
extends PlainSerializableType<String> {
    public static final StringSerializableType DEFAULT_STRING = new StringSerializableType(0, Integer.MAX_VALUE, null);
    private final int minLength;
    private final int maxLength;
    @Nullable
    private final Pattern pattern;

    public StringSerializableType(int minLength, int maxLength, @Nullable Pattern pattern) {
        super(String.class, StringConstraintChecker.instance());
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.pattern = pattern;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Nullable
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public <S> void serialize(TypeSerializer<S> serializer, S target) {
        serializer.serialize(this, target);
    }

    @Override
    public <S> S serializeValue(String value, ValueSerializer<S, ?> serializer) {
        return serializer.serializeString(value, this);
    }

    @Override
    public <S> String deserializeValue(S elem, ValueSerializer<S, ?> serializer) throws ValueDeserializationException {
        return serializer.deserializeString(elem, this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringSerializableType that = (StringSerializableType)o;
        return this.minLength == that.minLength && this.maxLength == that.maxLength && Objects.equals(this.pattern, that.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minLength, this.maxLength, this.pattern);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", StringSerializableType.class.getSimpleName() + "[", "]").add("minLength=" + this.minLength).add("maxLength=" + this.maxLength).add("pattern=" + this.pattern).toString();
    }
}

