/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.data;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.drex.villagerconfig.common.mixin.MerchantOfferAccessor;
import me.drex.villagerconfig.common.util.loot.VCLootContextParams;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_3218;
import net.minecraft.class_3853;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_5819;
import net.minecraft.class_75;
import net.minecraft.class_79;
import net.minecraft.class_82;
import net.minecraft.class_8567;
import net.minecraft.class_9306;
import net.minecraft.class_9331;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class BehaviorTrade
implements class_3853.class_1652 {
    public static final Codec<BehaviorTrade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_75.field_45802.fieldOf("cost_a").forGetter(behaviorTrade -> behaviorTrade.costA), (App)class_75.field_45802.optionalFieldOf("cost_b").forGetter(behaviorTrade -> behaviorTrade.costB), (App)class_75.field_45802.fieldOf("result").forGetter(behaviorTrade -> behaviorTrade.result), (App)class_5659.field_45888.optionalFieldOf("price_multiplier", (Object)class_44.method_32448((float)0.2f)).forGetter(behaviorTrade -> behaviorTrade.priceMultiplier), (App)class_5659.field_45888.optionalFieldOf("trader_experience", (Object)class_44.method_32448((float)0.0f)).forGetter(behaviorTrade -> behaviorTrade.traderExperience), (App)class_5659.field_45888.optionalFieldOf("max_uses", (Object)class_44.method_32448((float)12.0f)).forGetter(behaviorTrade -> behaviorTrade.maxUses), (App)class_5341.field_51809.listOf().optionalFieldOf("conditions", List.of()).forGetter(behaviorTrade -> behaviorTrade.conditions), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_5659.field_45888).optionalFieldOf("reference_providers", Map.of()).forGetter(behaviorTrade -> behaviorTrade.referenceProviders), (App)Codec.BOOL.optionalFieldOf("reward_experience", (Object)true).forGetter(behaviorTrade -> behaviorTrade.rewardExperience)).apply((Applicative)instance, BehaviorTrade::new));
    private final class_79 costA;
    private final Optional<class_79> costB;
    private final class_79 result;
    private final class_5658 priceMultiplier;
    private final class_5658 traderExperience;
    private final class_5658 maxUses;
    protected final Predicate<class_47> compositeCondition;
    private final List<class_5341> conditions;
    private final Map<String, class_5658> referenceProviders;
    private final boolean rewardExperience;

    BehaviorTrade(class_79 costA, Optional<class_79> costB, class_79 result, class_5658 priceMultiplier, class_5658 traderExperience, class_5658 maxUses, List<class_5341> conditions, Map<String, class_5658> referenceProviders, boolean rewardExperience) {
        this.costA = costA;
        this.costB = costB;
        this.result = result;
        this.priceMultiplier = priceMultiplier;
        this.traderExperience = traderExperience;
        this.maxUses = maxUses;
        this.conditions = conditions;
        this.compositeCondition = class_156.method_56613(conditions);
        this.referenceProviders = referenceProviders;
        this.rewardExperience = rewardExperience;
    }

    @Nullable
    public class_1914 method_7246(class_1297 entity, class_5819 random) {
        class_8567 lootParams = new class_8567.class_8568((class_3218)entity.method_37908()).method_51874(class_181.field_24424, (Object)entity.method_19538()).method_51874(class_181.field_1226, (Object)entity).method_51874(VCLootContextParams.NUMBER_REFERENCE, this.generateNumberReferences(entity, random)).method_51875(VCLootContextParams.VILLAGER_LOOT_CONTEXT);
        class_47 lootContext = new class_47.class_48(lootParams).method_309(Optional.empty());
        AtomicReference<class_1799> costA = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicReference<class_1799> costB = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicReference<class_1799> result = new AtomicReference<class_1799>(class_1799.field_8037);
        this.addRandomItem(result::set, lootContext, this.result);
        this.costB.ifPresent(container -> this.addRandomItem(costB::set, lootContext, (class_79)container));
        this.addRandomItem(costA::set, lootContext, this.costA);
        Optional<Object> itemCostB = Optional.empty();
        if (this.costB.isPresent()) {
            itemCostB = Optional.of(BehaviorTrade.convertToCost(costB.get()));
        }
        class_1914 tradeOffer = new class_1914(BehaviorTrade.convertToCost(costA.get()), itemCostB, result.get(), this.maxUses.method_366(lootContext), this.traderExperience.method_366(lootContext), this.priceMultiplier.method_32454(lootContext));
        ((MerchantOfferAccessor)tradeOffer).setRewardExp(this.rewardExperience);
        return tradeOffer;
    }

    private static class_9306 convertToCost(class_1799 stack) {
        class_9306 itemCost = new class_9306((class_1935)stack.method_7909(), stack.method_7947());
        return itemCost.method_57554(builder -> {
            for (Map.Entry componentPatch : stack.method_57380().method_57846()) {
                Optional value = (Optional)componentPatch.getValue();
                class_9331 key = (class_9331)componentPatch.getKey();
                value.ifPresent(o -> builder.method_57872(key, o));
            }
            return builder;
        });
    }

    private void addRandomItem(Consumer<class_1799> consumer, class_47 lootContext, class_79 lootPoolEntryContainer) {
        class_5819 randomSource = lootContext.method_294();
        ArrayList entries = Lists.newArrayList();
        MutableInt totalWeight = new MutableInt();
        lootPoolEntryContainer.expand(lootContext, lootPoolEntry -> {
            int weight = lootPoolEntry.method_427(lootContext.method_302());
            if (weight > 0) {
                entries.add(lootPoolEntry);
                totalWeight.add(weight);
            }
        });
        int size = entries.size();
        if (totalWeight.intValue() == 0 || size == 0) {
            return;
        }
        if (size == 1) {
            ((class_82)entries.getFirst()).method_426(itemStack -> BehaviorTrade.limitCount(consumer, itemStack), lootContext);
            return;
        }
        int j = randomSource.method_43048(totalWeight.intValue());
        for (class_82 lootPoolEntry2 : entries) {
            if ((j -= lootPoolEntry2.method_427(lootContext.method_302())) >= 0) continue;
            lootPoolEntry2.method_426(itemStack -> BehaviorTrade.limitCount(consumer, itemStack), lootContext);
            return;
        }
    }

    private static void limitCount(Consumer<class_1799> consumer, class_1799 itemStack) {
        consumer.accept(itemStack.method_46651(Math.min(itemStack.method_7914(), itemStack.method_7947())));
    }

    private Map<String, Float> generateNumberReferences(class_1297 entity, class_5819 random) {
        class_8567 lootParams = new class_8567.class_8568((class_3218)entity.method_37908()).method_51875(class_173.field_1175);
        class_47 simpleContext = new class_47.class_48(lootParams).method_309(Optional.empty());
        return this.referenceProviders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Float.valueOf(((class_5658)entry.getValue()).method_32454(simpleContext))));
    }

    public static class Builder {
        private final class_79 costA;
        private Optional<class_79> costB = Optional.empty();
        private final class_79 result;
        private class_5658 priceMultiplier = class_44.method_32448((float)0.2f);
        private class_5658 traderExperience = class_44.method_32448((float)1.0f);
        private class_5658 maxUses = class_44.method_32448((float)12.0f);
        private final List<class_5341> conditions = Lists.newArrayList();
        private final Map<String, class_5658> referenceProviders = new HashMap<String, class_5658>();
        private boolean rewardExperience = true;

        public Builder(class_79.class_80<?> costA, class_79.class_80<?> result) {
            this.costA = costA.method_419();
            this.result = result.method_419();
        }

        public Builder(class_79.class_80<?> costA, class_79.class_80<?> costB, class_79.class_80<?> result) {
            this.costA = costA.method_419();
            this.costB = Optional.of(costB.method_419());
            this.result = result.method_419();
        }

        public Builder priceMultiplier(float priceMultiplier) {
            return this.priceMultiplier((class_5658)class_44.method_32448((float)priceMultiplier));
        }

        public Builder priceMultiplier(class_5658 priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder traderExperience(float traderExp) {
            return this.traderExperience((class_5658)class_44.method_32448((float)traderExp));
        }

        public Builder traderExperience(class_5658 traderExp) {
            this.traderExperience = traderExp;
            return this;
        }

        public Builder when(class_5341.class_210 builder) {
            this.conditions.add(builder.build());
            return this;
        }

        public Builder maxUses(float maxUses) {
            return this.maxUses((class_5658)class_44.method_32448((float)maxUses));
        }

        public Builder maxUses(class_5658 maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public Builder numberReference(String id, class_5658 numberProvider) {
            this.referenceProviders.put(id, numberProvider);
            return this;
        }

        public Builder rewardExperience(boolean rewardExp) {
            this.rewardExperience = rewardExp;
            return this;
        }

        public BehaviorTrade build() {
            return new BehaviorTrade(this.costA, this.costB, this.result, this.priceMultiplier, this.traderExperience, this.maxUses, this.conditions, this.referenceProviders, this.rewardExperience);
        }
    }
}

