/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.data.TradeTable;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TradeManager
extends class_4309 {
    public static final class_2960 ID = class_2960.method_60655((String)"villagerconfig", (String)"trades");
    private static final Logger LOGGER = VillagerConfig.LOGGER;
    private Map<class_2960, TradeTable> trades = ImmutableMap.of();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final class_7225.class_7874 provider;

    public TradeManager(class_7225.class_7874 provider) {
        super(GSON, "trades");
        this.provider = provider;
    }

    @Nullable
    public TradeTable getTrade(class_2960 id) {
        return this.trades.get(id);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        prepared.forEach((identifier, jsonElement) -> {
            try {
                TradeTable table = (TradeTable)TradeTable.CODEC.parse(this.registryOps(), jsonElement).getOrThrow();
                builder.put(identifier, (Object)table);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to load trade {}", identifier, (Object)exception);
            }
        });
        this.trades = builder.build();
        LOGGER.info("Loaded {} trades", (Object)this.trades.size());
    }

    public class_6903<JsonElement> registryOps() {
        return this.provider.method_57093((DynamicOps)JsonOps.INSTANCE);
    }
}

