/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.drex.villagerconfig.common.data.BehaviorTrade;
import me.drex.villagerconfig.common.data.TradeGroup;
import me.drex.villagerconfig.common.data.TradeTable;
import me.drex.villagerconfig.common.data.TradeTier;
import me.drex.villagerconfig.common.mixin.VillagerDataAccessor;
import me.drex.villagerconfig.common.util.loot.function.EnchantRandomlyLootFunction;
import me.drex.villagerconfig.common.util.loot.function.SetDyeFunction;
import me.drex.villagerconfig.common.util.loot.number.AddLootNumberProvider;
import me.drex.villagerconfig.common.util.loot.number.MultiplyLootNumberProvider;
import me.drex.villagerconfig.common.util.loot.number.ReferenceLootNumberProvider;
import net.minecraft.class_106;
import net.minecraft.class_111;
import net.minecraft.class_117;
import net.minecraft.class_1291;
import net.minecraft.class_141;
import net.minecraft.class_152;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2105;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_2405;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3670;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5642;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6662;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7699;
import net.minecraft.class_77;
import net.minecraft.class_7784;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import net.minecraft.class_9298;
import net.minecraft.class_93;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.class_9741;
import net.minecraft.class_9745;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class TradeProvider
implements class_2405 {
    private final class_7784.class_7489 pathResolver;
    private final CompletableFuture<class_7225.class_7874> registries;
    private final boolean experimental;
    private final class_1845 potionBrewing;
    public static final class_2960 WANDERING_TRADER_ID = class_2960.method_60656((String)"wanderingtrader");
    private static final IntUnaryOperator EXPERIMENTAL1_21_4_WANDERING_TRADER_COUNT = i -> {
        List trades = class_3853.field_45129;
        if (i > trades.size()) {
            return 0;
        }
        return (Integer)((Pair)trades.get(i - 1)).getValue();
    };
    private static final IntUnaryOperator WANDERING_TRADER_COUNT = i -> switch (i) {
        case 1 -> 5;
        case 2 -> 1;
        default -> 0;
    };

    public TradeProvider(class_7784 output, CompletableFuture<class_7225.class_7874> registries, boolean experimental, class_7699 featureFlags) {
        this.pathResolver = output.method_45973(class_7784.class_7490.field_39367, "trades");
        this.registries = registries;
        this.experimental = experimental;
        this.potionBrewing = class_1845.method_8076((class_7699)featureFlags);
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 writer) {
        return this.registries.thenCompose(provider -> this.run(writer, (class_7225.class_7874)provider));
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull class_7403 writer, class_7225.class_7874 provider) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry2 : class_7923.field_41195.method_29722()) {
            class_5321 key = (class_5321)entry2.getKey();
            class_3852 tradeKey = (class_3852)entry2.getValue();
            Int2ObjectMap trades = (Int2ObjectMap)class_3853.field_17067.getOrDefault(tradeKey, new Int2ObjectArrayMap());
            Int2ObjectMap experimentalTrades = (Int2ObjectMap)class_3853.field_45128.get(tradeKey);
            if (this.experimental && experimentalTrades != null) {
                trades = experimentalTrades;
            }
            map.put(key.method_29177(), new TradeData((Int2ObjectMap<class_3853.class_1652[]>)trades, OfferCountType.VILLAGER, true));
        }
        if (this.experimental) {
            Int2ObjectArrayMap experimentalTrades = new Int2ObjectArrayMap();
            List experimentalWanderingTraderTrades = class_3853.field_45129;
            for (int i = 0; i < experimentalWanderingTraderTrades.size(); ++i) {
                Pair pair = (Pair)experimentalWanderingTraderTrades.get(i);
                experimentalTrades.put(i + 1, (Object)((class_3853.class_1652[])pair.getLeft()));
            }
            map.put(WANDERING_TRADER_ID, new TradeData((Int2ObjectMap<class_3853.class_1652[]>)experimentalTrades, OfferCountType.EXPERIMENTAL_WANDERING_TRADER, false));
        } else {
            map.put(WANDERING_TRADER_ID, new TradeData((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724, OfferCountType.WANDERING_TRADER, false));
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            TradeTier[] tiers;
            class_2960 id = (class_2960)entry.getKey();
            TradeData tradeData = (TradeData)entry.getValue();
            Path path = this.pathResolver.method_44107(id);
            int maxLevel = 0;
            while (tradeData.trades().containsKey(maxLevel + 1)) {
                ++maxLevel;
            }
            TradeGroup[] tradeGroups = new TradeGroup[maxLevel];
            tradeData.trades().forEach((level, factoryArr) -> {
                TradeGroup tradeGroup;
                if (level <= 0 || level > tradeGroups.length) {
                    field_40831.warn("Invalid trade level {}, expected 1 - {}, for villager type {}", new Object[]{level, tradeGroups.length, id});
                    return;
                }
                tradeGroups[level.intValue() - 1] = tradeGroup = new TradeGroup((class_5658)class_44.method_32448((float)tradeData.offerCountType().getOfferCount((int)level)), Arrays.stream(factoryArr).map(itemListing -> this.convert((class_3853.class_1652)itemListing, id, provider)).flatMap(Stream::of).map(BehaviorTrade.Builder::build).filter(Objects::nonNull).toList());
            });
            if (tradeData.useTiers()) {
                tiers = new TradeTier[maxLevel];
                for (int i = 0; i < tradeGroups.length; ++i) {
                    tiers[i] = new TradeTier(VillagerDataAccessor.getNextLevelXpThresholds()[i], List.of(tradeGroups[i]));
                }
            } else {
                tiers = new TradeTier[]{new TradeTier(0, List.of(tradeGroups))};
            }
            TradeTable tradeTable = new TradeTable(List.of(tiers));
            return class_2405.method_53496((class_7403)writer, (class_7225.class_7874)provider, TradeTable.CODEC, (Object)tradeTable, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String method_10321() {
        return "Trades";
    }

    private BehaviorTrade.Builder[] convert(class_3853.class_1652 original, class_2960 id, class_7225.class_7874 provider) {
        if (original instanceof class_3853.class_4161) {
            class_3853.class_4161 factory = (class_3853.class_4161)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)TradeProvider.lootTableItemStack(factory.field_45130.comp_2427()), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18549)))).priceMultiplier(factory.field_18552).traderExperience(factory.field_18551).maxUses(factory.field_18550)};
        }
        if (original instanceof class_3853.class_4165) {
            class_3853.class_4165 factory = (class_3853.class_4165)original;
            class_85.class_86<?> result = TradeProvider.lootTableItemStack(factory.field_18571);
            this.enchantItem(result, factory.field_51619, (class_3853.class_1652)factory, provider);
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18572))), (class_79.class_80<?>)result).priceMultiplier(factory.field_18576).traderExperience(factory.field_18575).maxUses(factory.field_18574)};
        }
        if (original instanceof class_3853.class_4166) {
            class_3853.class_4166 factory = (class_3853.class_4166)original;
            class_85.class_86 suspciousStewBuilder = class_77.method_411((class_1935)class_1802.field_8766);
            for (class_9298.class_8751 effect : factory.field_45756.comp_2416()) {
                int duration = effect.comp_1839();
                if (!((class_1291)effect.comp_1838().comp_349()).method_5561()) {
                    duration /= 20;
                }
                suspciousStewBuilder.method_438((class_117.class_118)new class_152.class_153().method_640(effect.comp_1838(), (class_5658)class_44.method_32448((float)duration)));
            }
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687), (class_79.class_80<?>)suspciousStewBuilder).traderExperience(factory.field_18579)};
        }
        if (original instanceof class_3853.class_4164) {
            class_3853.class_4164 factory = (class_3853.class_4164)original;
            class_85.class_86<?> result = TradeProvider.lootTableItemStack(factory.field_18566);
            this.enchantItem(result, factory.field_51618, (class_3853.class_1652)factory, provider);
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18565))), (class_79.class_80<?>)TradeProvider.lootTableItemStack(factory.field_18563.comp_2427()), (class_79.class_80<?>)result).priceMultiplier(factory.field_18570).traderExperience(factory.field_18569).maxUses(factory.field_18568)};
        }
        if (original instanceof class_3853.class_4163) {
            class_3853.class_4163 factory = (class_3853.class_4163)original;
            Optional optional = provider.method_46762(class_7924.field_41265).method_46733(class_9636.field_51549);
            class_106.class_107 builder = new class_106.class_107((class_5658)ReferenceLootNumberProvider.create("enchantLevel"));
            optional.ifPresent(arg_0 -> ((class_106.class_107)builder).method_60295(arg_0));
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18559))).method_438((class_117.class_118)class_141.method_35540((class_5658)ReferenceLootNumberProvider.create("enchantLevel"), (boolean)true)), (class_79.class_80<?>)TradeProvider.lootTableItemStack(factory.field_18558).method_438((class_117.class_118)builder)).priceMultiplier(factory.field_18562).traderExperience(factory.field_18561).maxUses(factory.field_18560).numberReference("enchantLevel", (class_5658)class_5662.method_32462((float)5.0f, (float)19.0f))};
        }
        if (original instanceof class_3853.class_4162) {
            class_3853.class_4162 factory = (class_3853.class_4162)original;
            ArrayList<BehaviorTrade.Builder> trades = new ArrayList<BehaviorTrade.Builder>(factory.field_18553.size());
            for (Map.Entry entry : TradeProvider.sortedEntrySet(factory.field_18553.entrySet())) {
                class_2487 root = new class_2487();
                class_2487 villagerData = new class_2487();
                villagerData.method_10582("type", class_7923.field_41194.method_10221((Object)entry.getKey()).toString());
                root.method_10566("VillagerData", (class_2520)villagerData);
                BehaviorTrade.Builder trade = new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)((class_1935)factory.field_18553.get(entry.getKey()))).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18554))), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687)).priceMultiplier(0.05f).traderExperience(factory.field_18556).maxUses(factory.field_18555).when(class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_8915(new class_2105(root))));
                trades.add(trade);
            }
            return (BehaviorTrade.Builder[])trades.toArray(BehaviorTrade.Builder[]::new);
        }
        if (original instanceof class_3853.class_4167) {
            class_3853.class_4167 factory = (class_3853.class_4167)original;
            List potions = class_7923.field_41179.method_40270().filter(reference -> !((class_1842)reference.comp_349()).method_8049().isEmpty() && this.potionBrewing.method_20361((class_6880)reference)).collect(Collectors.toList());
            class_79.class_80[] entries = new class_79.class_80[potions.size()];
            for (int i = 0; i < potions.size(); ++i) {
                class_6880 potion = (class_6880)potions.get(i);
                entries[i] = TradeProvider.lootTableItemStack(factory.field_18581).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18582))).method_438((class_117.class_118)class_6662.method_38927((class_6880)potion));
            }
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18583))), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18586).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18587))), (class_79.class_80<?>)class_93.method_35511((class_79.class_80[])entries)).priceMultiplier(factory.field_18588).traderExperience(factory.field_18585).maxUses(factory.field_18584)};
        }
        if (original instanceof class_3853.class_1648) {
            class_3853.class_1648 factory = (class_3853.class_1648)original;
            EnchantRandomlyLootFunction.Builder enchantRandomlyFunction = new EnchantRandomlyLootFunction.Builder().minLevel(factory.field_45132).maxLevel(factory.field_45133).include((class_6885<class_1887>)provider.method_46762(class_7924.field_41265).method_46735(factory.field_45131));
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)MultiplyLootNumberProvider.create(AddLootNumberProvider.create(new class_5658[]{class_44.method_32448((float)2.0f), new class_5662((class_5658)class_44.method_32448((float)0.0f), (class_5658)AddLootNumberProvider.create(new class_5658[]{class_44.method_32448((float)5.0f), MultiplyLootNumberProvider.create(new class_5658[]{ReferenceLootNumberProvider.create("enchantmentLevel"), class_44.method_32448((float)10.0f)})})), MultiplyLootNumberProvider.create(new class_5658[]{class_44.method_32448((float)3.0f), ReferenceLootNumberProvider.create("enchantmentLevel")})}), ReferenceLootNumberProvider.create("treasureMultiplier")))), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8529), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8529).method_438((class_117.class_118)enchantRandomlyFunction)).traderExperience(factory.field_18557)};
        }
        if (original instanceof class_3853.class_1654) {
            class_3853.class_1654 factory = (class_3853.class_1654)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18589))), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8251), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8895).method_438((class_117.class_118)new class_111.class_112().method_35521(100).method_499(factory.field_7473).method_502(factory.field_7474).method_500((byte)2).method_503(true)).method_438((class_117.class_118)class_3670.method_35549((class_2561)class_2561.method_43471((String)factory.field_37051), (class_3670.class_9475)class_3670.class_9475.field_50211))).traderExperience(factory.field_18591).maxUses(factory.field_18590)};
        }
        if (original instanceof class_3853.class_4160) {
            class_3853.class_4160 factory = (class_3853.class_4160)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18545))), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18544).method_438((class_117.class_118)new SetDyeFunction.Builder(true)).method_438((class_117.class_118)new SetDyeFunction.Builder(true).method_524(class_219.method_932((float)0.3f))).method_438((class_117.class_118)new SetDyeFunction.Builder(true).method_524(class_219.method_932((float)0.2f)))).traderExperience(factory.field_18547).maxUses(factory.field_18546)};
        }
        if (original instanceof class_3853.class_8640) {
            class_3853.class_8640 factory = (class_3853.class_8640)original;
            ArrayList<BehaviorTrade.Builder> trades = new ArrayList<BehaviorTrade.Builder>(factory.comp_1962().size());
            for (Map.Entry entry : TradeProvider.sortedEntrySet(factory.comp_1962().entrySet())) {
                class_2487 root = new class_2487();
                class_2487 villagerData = new class_2487();
                villagerData.method_10582("type", class_7923.field_41194.method_10221((Object)entry.getKey()).toString());
                root.method_10566("VillagerData", (class_2520)villagerData);
                for (BehaviorTrade.Builder behaviorTrade : this.convert((class_3853.class_1652)entry.getValue(), id, provider)) {
                    behaviorTrade.when(class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_8915(new class_2105(root))));
                    trades.add(behaviorTrade);
                }
            }
            return (BehaviorTrade.Builder[])trades.toArray(BehaviorTrade.Builder[]::new);
        }
        field_40831.warn("Unable to convert {}: {} for {}, generated json won't be complete!", new Object[]{original.getClass(), original, id});
        return new BehaviorTrade.Builder[0];
    }

    private void enchantItem(class_85.class_86<?> builder, Optional<class_5321<class_9741>> optional, class_3853.class_1652 factory, class_7225.class_7874 provider) {
        if (optional.isPresent()) {
            class_9745 singleEnchantment;
            class_6017 class_60172;
            class_9741 enchantmentProvider = (class_9741)provider.method_46762(class_7924.field_51839).method_46747(optional.get()).comp_349();
            if (enchantmentProvider instanceof class_9745 && (class_60172 = (singleEnchantment = (class_9745)enchantmentProvider).comp_2770()) instanceof class_6016) {
                class_6016 constantInt = (class_6016)class_60172;
                builder.method_438((class_117.class_118)new class_5642.class_6158().method_35539(singleEnchantment.comp_2769(), (class_5658)new class_44((float)constantInt.method_34997())));
            } else {
                field_40831.warn("Failed to generate trades '{}', encountered unexpected enchantment provider '{}'.", (Object)factory, (Object)enchantmentProvider);
            }
        }
    }

    private static <T> List<Map.Entry<class_3854, T>> sortedEntrySet(Set<Map.Entry<class_3854, T>> entrySet) {
        return entrySet.stream().sorted(Comparator.comparing(o -> ((class_3854)o.getKey()).toString())).toList();
    }

    private static class_85.class_86<?> lootTableItemStack(class_1799 itemStack) {
        class_85.class_86 builder = class_77.method_411((class_1935)itemStack.method_7909());
        if (itemStack.method_7947() != 1) {
            builder.method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)itemStack.method_7947())));
        }
        class_9304 enchantments = (class_9304)itemStack.method_57825(class_9334.field_49633, (Object)class_9304.field_49385);
        enchantments.method_57539().forEach(holderEntry -> builder.method_438((class_117.class_118)new class_5642.class_6158(true).method_35539((class_6880)holderEntry.getKey(), (class_5658)class_44.method_32448((float)holderEntry.getIntValue()))));
        class_1844 potionContents = (class_1844)itemStack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
        potionContents.comp_2378().ifPresent(potionHolder -> builder.method_438((class_117.class_118)class_6662.method_38927((class_6880)potionHolder)));
        return builder;
    }

    public record TradeData(Int2ObjectMap<class_3853.class_1652[]> trades, OfferCountType offerCountType, boolean useTiers) {
    }

    public static enum OfferCountType {
        VILLAGER(i -> 2),
        WANDERING_TRADER(WANDERING_TRADER_COUNT),
        EXPERIMENTAL_WANDERING_TRADER(EXPERIMENTAL1_21_4_WANDERING_TRADER_COUNT);

        private final IntUnaryOperator operator;

        private OfferCountType(IntUnaryOperator operator) {
            this.operator = operator;
        }

        public int getOfferCount(int level) {
            return this.operator.apply(level);
        }
    }
}

