/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.config.Config;
import me.drex.villagerconfig.common.platform.PlatformHooks;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.annotation.AnnotatedSettings;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.annotation.SettingNamingConvention;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.exception.FiberException;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;

public class ConfigManager {
    public static final Path CONFIG_PATH = PlatformHooks.PLATFORM_HELPER.getModConfigDir().resolve("villagerconfig.json5");
    private static final AnnotatedSettings ANNOTATED_SETTINGS = AnnotatedSettings.builder().useNamingConvention(SettingNamingConvention.SNAKE_CASE).build();
    public static final Config CONFIG = new Config();
    public static final ConfigTree TREE = ConfigTree.builder().applyFromPojo(CONFIG, ANNOTATED_SETTINGS).build();
    private static final JanksonValueSerializer serializer = new JanksonValueSerializer(false);

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                ANNOTATED_SETTINGS.applyToNode(TREE, CONFIG);
                FiberSerialization.deserialize(TREE, Files.newInputStream(CONFIG_PATH, new OpenOption[0]), serializer);
            }
            catch (IOException | FiberException e) {
                VillagerConfig.LOGGER.error("Failed to load config file!", (Throwable)e);
            }
        } else {
            ConfigManager.saveModConfig();
        }
    }

    public static void saveModConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            ANNOTATED_SETTINGS.applyToNode(TREE, CONFIG);
            FiberSerialization.serialize(TREE, Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), serializer);
        }
        catch (IOException | FiberException e) {
            VillagerConfig.LOGGER.error("Failed to save config file!", (Throwable)e);
        }
    }
}

