/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.protocol;

import java.util.Arrays;
import me.drex.villagerconfig.common.util.duck.IMerchantMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public record ClientboundMerchantXpPacket(int containerId, int maxLevel, int[] nextLevelXpThresholds) implements CustomPacketPayload
{
    public static final ResourceLocation PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"villagerconfig", (String)"merchant_xp_packet");
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    CustomPacketPayload.Type<@NotNull ClientboundMerchantXpPacket> ID = new CustomPacketPayload.Type(PACKET_ID);
    public static final StreamCodec<@NotNull RegistryFriendlyByteBuf, @NotNull ClientboundMerchantXpPacket> CODEC = StreamCodec.of(ClientboundMerchantXpPacket::writeToStream, ClientboundMerchantXpPacket::createFromStream);

    @NotNull
    private static ClientboundMerchantXpPacket createFromStream(@NotNull RegistryFriendlyByteBuf buf) {
        return new ClientboundMerchantXpPacket(buf.readInt(), buf.readInt(), Arrays.stream(buf.readLongArray()).mapToInt(i -> (int)i).toArray());
    }

    private static void writeToStream(@NotNull RegistryFriendlyByteBuf buf, @NotNull ClientboundMerchantXpPacket packet) {
        buf.writeInt(packet.containerId);
        buf.writeInt(packet.maxLevel);
        buf.writeLongArray(Arrays.stream(packet.nextLevelXpThresholds).mapToLong(i -> i).toArray());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    CustomPacketPayload.Type<? extends @NotNull CustomPacketPayload> type() {
        return ID;
    }

    public void handle(Player player) {
        AbstractContainerMenu menu = player.containerMenu;
        if (this.containerId == menu.containerId && menu instanceof IMerchantMenu) {
            IMerchantMenu duck = (IMerchantMenu)menu;
            duck.villagerConfig$init(this.maxLevel, this.nextLevelXpThresholds);
        }
    }
}

