/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util.loot.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.drex.villagerconfig.common.util.loot.LootNumberProviderTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.NotNull;

public record MultiplyLootNumberProvider(List<NumberProvider> factors) implements NumberProvider
{
    public static final MapCodec<MultiplyLootNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.listOf().fieldOf("factors").forGetter(MultiplyLootNumberProvider::factors)).apply((Applicative)instance, MultiplyLootNumberProvider::new));

    public float getFloat(@NotNull LootContext context) {
        float result = 1.0f;
        for (NumberProvider addend : this.factors) {
            result *= addend.getFloat(context);
        }
        return result;
    }

    @NotNull
    public LootNumberProviderType getType() {
        return LootNumberProviderTypes.MUL;
    }

    public static MultiplyLootNumberProvider create(NumberProvider ... factors) {
        return new MultiplyLootNumberProvider(List.of(factors));
    }
}

