/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.shadow.fablabsmc.fablabs.impl.fiber.constraint;

import java.math.BigDecimal;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type.DecimalSerializableType;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type.TypeCheckResult;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.impl.fiber.constraint.ConstraintChecker;

public final class DecimalConstraintChecker
extends ConstraintChecker<BigDecimal, DecimalSerializableType> {
    private static final DecimalConstraintChecker INSTANCE = new DecimalConstraintChecker();

    public static DecimalConstraintChecker instance() {
        return INSTANCE;
    }

    private DecimalConstraintChecker() {
    }

    @Override
    public TypeCheckResult<BigDecimal> test(DecimalSerializableType cfg, BigDecimal value) {
        if (cfg.getMinimum() != null && cfg.getMinimum().compareTo(value) > 0) {
            return TypeCheckResult.failed(cfg.getMinimum());
        }
        if (cfg.getMaximum() != null && cfg.getMaximum().compareTo(value) < 0) {
            return TypeCheckResult.failed(cfg.getMaximum());
        }
        if (cfg.getIncrement() != null && value.remainder(cfg.getIncrement()).intValue() != 0) {
            if (cfg.getMinimum() != null) {
                return TypeCheckResult.failed(DecimalConstraintChecker.fit(value, cfg.getMinimum(), cfg.getIncrement()));
            }
            return TypeCheckResult.unrecoverable();
        }
        return TypeCheckResult.successful(value);
    }

    @Override
    public boolean comprehends(DecimalSerializableType cfg, DecimalSerializableType cfg2) {
        if ((cfg.getMinimum() == null || cfg2.getMinimum() != null && cfg.getMinimum().compareTo(cfg2.getMinimum()) <= 0) && (cfg.getMaximum() == null || cfg2.getMaximum() != null && cfg.getMaximum().compareTo(cfg2.getMaximum()) >= 0)) {
            return cfg.getIncrement() == null || cfg2.getIncrement() != null && cfg2.getIncrement().remainder(cfg.getIncrement()).compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }

    private static BigDecimal nearest(BigDecimal less, BigDecimal value, BigDecimal more) {
        BigDecimal moreDiff;
        BigDecimal lessDiff = value.subtract(less);
        if (lessDiff.compareTo(moreDiff = more.subtract(value)) < 0) {
            return less;
        }
        return more;
    }

    private static BigDecimal fit(BigDecimal value, BigDecimal min, BigDecimal step) {
        BigDecimal prevTick = value.subtract(min).divide(step, 3).setScale(0, 1);
        BigDecimal prevTickValue = prevTick.multiply(step).add(min);
        BigDecimal nextTickValue = prevTick.add(BigDecimal.ONE).multiply(step).add(min);
        return DecimalConstraintChecker.nearest(prevTickValue, value, nextTickValue);
    }
}

