/*
 * Decompiled with CFR 0.152.
 */
package com.g2806.tntimer;

import com.g2806.tntimer.TNTimerConfig;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1541;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNTCountdown
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TNTCountdown.class);
    private static class_304 configKey;

    public void onInitializeClient() {
        TNTimerConfig.getInstance();
        LOGGER.info("TNTCountdown: Configuration loaded!");
        HudElementRegistry.addLast((class_2960)class_2960.method_60655((String)"tntimer", (String)"countdown"), (context, tickCounter) -> {
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.field_1687 == null) {
                return;
            }
            TNTimerConfig config = TNTimerConfig.getInstance();
            if (!config.enabled) {
                return;
            }
            ArrayList<class_1541> tntEntities = new ArrayList<class_1541>();
            for (class_1297 entity : mc.field_1687.method_18112()) {
                if (!(entity instanceof class_1541)) continue;
                class_1541 tnt = (class_1541)entity;
                tntEntities.add(tnt);
            }
            if (tntEntities.isEmpty()) {
                return;
            }
            int screenWidth = mc.method_22683().method_4486();
            int screenHeight = mc.method_22683().method_4502();
            int padding = 10;
            int displayCount = Math.min(tntEntities.size(), config.maxTntDisplay);
            for (int i = 0; i < displayCount; ++i) {
                int y;
                int x;
                class_1541 tnt = (class_1541)tntEntities.get(i);
                int fuse = tnt.method_6969();
                double seconds = (double)fuse / 20.0;
                String formattedSeconds = String.format("%.1f", seconds).replace(',', '.');
                String timeLeft = config.showOnlySeconds ? formattedSeconds + "s" : "TNT: " + formattedSeconds + "s";
                int color = -1;
                if (fuse < 20) {
                    color = -65536;
                } else if (fuse < 40) {
                    color = Short.MIN_VALUE;
                }
                int textWidth = mc.field_1772.method_1727(timeLeft);
                Objects.requireNonNull(mc.field_1772);
                int textHeight = 9;
                int bottomY = screenHeight - (textHeight + padding) - i * (textHeight + 5);
                switch (config.position) {
                    case TOP_LEFT: {
                        x = padding;
                        y = padding + i * (textHeight + 5);
                        break;
                    }
                    case TOP_RIGHT: {
                        x = screenWidth - textWidth - padding;
                        y = padding + i * (textHeight + 5);
                        break;
                    }
                    case BOTTOM_LEFT: {
                        x = padding;
                        y = bottomY;
                        break;
                    }
                    case BOTTOM_RIGHT: {
                        x = screenWidth - textWidth - padding;
                        y = bottomY;
                        break;
                    }
                    case TOP_CENTER: {
                        x = screenWidth / 2 - textWidth / 2;
                        y = padding + i * (textHeight + 5);
                        break;
                    }
                    case BOTTOM_CENTER: {
                        x = screenWidth / 2 - textWidth / 2;
                        y = screenHeight - 60 - i * (textHeight + 5);
                        break;
                    }
                    case UNDER_CURSOR: {
                        x = screenWidth / 2 - textWidth / 2;
                        y = screenHeight / 2 + 15 + i * (textHeight + 5);
                        y = Math.min(y, screenHeight - textHeight - 5);
                        y = Math.max(y, 5);
                        break;
                    }
                    default: {
                        x = padding;
                        y = padding + i * (textHeight + 5);
                    }
                }
                if (config.showBackground) {
                    int backgroundPadding = 2;
                    int backgroundX = x - backgroundPadding;
                    int backgroundY = y - backgroundPadding;
                    int backgroundWidth = textWidth + backgroundPadding * 2;
                    int backgroundHeight = textHeight + backgroundPadding * 2;
                    int backgroundColor = Integer.MIN_VALUE;
                    context.method_25294(backgroundX, backgroundY, backgroundX + backgroundWidth, backgroundY + backgroundHeight, backgroundColor);
                }
                context.method_25303(mc.field_1772, timeLeft, x, y, color);
            }
        });
        LOGGER.info("TNTCountdown: Loaded successfully!");
        System.out.println("TNTCountdown: Press K to open configuration");
    }
}

