/*
 * Decompiled with CFR 0.152.
 */
package com.g2806.tntimer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TNTimerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TNTimerConfig.class);
    private static TNTimerConfig instance;
    public Position position = Position.TOP_LEFT;
    public int maxTntDisplay = 5;
    public boolean enabled = true;
    public boolean showOnlySeconds = false;
    public boolean showBackground = false;

    public static TNTimerConfig getInstance() {
        if (instance == null) {
            instance = TNTimerConfig.load();
        }
        return instance;
    }

    public static TNTimerConfig load() {
        File configFile = new File(class_310.method_1551().field_1697, "config/tntimer.json");
        Gson gson = new Gson();
        TNTimerConfig config = new TNTimerConfig();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                TNTimerConfig loaded = (TNTimerConfig)gson.fromJson((Reader)reader, TNTimerConfig.class);
                if (loaded != null) {
                    config = loaded;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config file: {}", (Object)configFile.getAbsolutePath(), (Object)e);
            }
        }
        return config;
    }

    public void save() {
        File configDir = new File(class_310.method_1551().field_1697, "config");
        File configFile = new File(configDir, "tntimer.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!configDir.exists() && !configDir.mkdirs()) {
            LOGGER.error("Failed to create config directory: {}", (Object)configDir.getAbsolutePath());
            return;
        }
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config file: {}", (Object)configFile.getAbsolutePath(), (Object)e);
        }
    }

    public static enum Position {
        TOP_LEFT("tntimer.position.top_left"),
        TOP_RIGHT("tntimer.position.top_right"),
        BOTTOM_LEFT("tntimer.position.bottom_left"),
        BOTTOM_RIGHT("tntimer.position.bottom_right"),
        TOP_CENTER("tntimer.position.top_center"),
        BOTTOM_CENTER("tntimer.position.bottom_center"),
        UNDER_CURSOR("tntimer.position.under_cursor");

        private final String translationKey;

        private Position(String translationKey) {
            this.translationKey = translationKey;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)this.translationKey);
        }

        public String toString() {
            return class_2561.method_43471((String)this.translationKey).getString();
        }
    }
}

