/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.common;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import me.erykczy.colorfullighting.common.ColoredLightStorage;
import me.erykczy.colorfullighting.common.Config;
import me.erykczy.colorfullighting.common.accessors.BlockStateAccessor;
import me.erykczy.colorfullighting.common.accessors.ClientAccessor;
import me.erykczy.colorfullighting.common.accessors.LevelAccessor;
import me.erykczy.colorfullighting.common.accessors.PlayerAccessor;
import me.erykczy.colorfullighting.common.util.ColorRGB4;
import me.erykczy.colorfullighting.common.util.ColorRGB8;
import me.erykczy.colorfullighting.common.util.MathExt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public class ColoredLightEngine {
    public ClientAccessor clientAccessor;
    private ColoredLightStorage storage = new ColoredLightStorage();
    private Queue<LightUpdateRequest> propagateIncreases = new ConcurrentLinkedQueue<LightUpdateRequest>();
    private Queue<LightUpdateRequest> propagateDecreases = new LinkedList<LightUpdateRequest>();
    private LinkedList<Long> dirtySections = new LinkedList();
    private Queue<ChunkPos> newChunks = new ConcurrentLinkedQueue<ChunkPos>();
    private HashSet<ChunkPos> fullyLoadedChunks = new HashSet();
    private Thread handleNewChunksThread;
    private static ColoredLightEngine instance;

    public static ColoredLightEngine getInstance() {
        return instance;
    }

    public static void create(ClientAccessor clientAccessor) {
        instance = new ColoredLightEngine(clientAccessor);
    }

    private ColoredLightEngine(ClientAccessor clientAccessor) {
        this.clientAccessor = clientAccessor;
        this.handleNewChunksThread = new Thread(new PropagateLightInNewChunks());
        this.handleNewChunksThread.start();
    }

    public ColorRGB4 sampleLightColor(BlockPos pos) {
        return this.sampleLightColor(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public ColorRGB4 sampleLightColor(int x, int y, int z) {
        ColorRGB4 entry = this.storage.getEntry(x, y, z);
        if (entry == null) {
            return ColorRGB4.fromRGB4(0, 0, 0);
        }
        return entry;
    }

    public ColorRGB8 sampleTrilinearLightColor(Vec3 pos) {
        int cornerX = (int)Math.round(pos.f_82479_) - 1;
        int cornerY = (int)Math.round(pos.f_82480_) - 1;
        int cornerZ = (int)Math.round(pos.f_82481_) - 1;
        ColorRGB8 c000 = ColorRGB8.fromRGB4(this.sampleLightColor(cornerX + 0, cornerY + 0, cornerZ + 0));
        ColorRGB8 c100 = ColorRGB8.fromRGB4(this.sampleLightColor(cornerX + 1, cornerY + 0, cornerZ + 0));
        ColorRGB8 c101 = ColorRGB8.fromRGB4(this.sampleLightColor(cornerX + 1, cornerY + 0, cornerZ + 1));
        ColorRGB8 c001 = ColorRGB8.fromRGB4(this.sampleLightColor(cornerX + 0, cornerY + 0, cornerZ + 1));
        ColorRGB8 c010 = ColorRGB8.fromRGB4(this.sampleLightColor(cornerX + 0, cornerY + 1, cornerZ + 0));
        ColorRGB8 c110 = ColorRGB8.fromRGB4(this.sampleLightColor(cornerX + 1, cornerY + 1, cornerZ + 0));
        ColorRGB8 c111 = ColorRGB8.fromRGB4(this.sampleLightColor(cornerX + 1, cornerY + 1, cornerZ + 1));
        ColorRGB8 c011 = ColorRGB8.fromRGB4(this.sampleLightColor(cornerX + 0, cornerY + 1, cornerZ + 1));
        double x = (pos.f_82479_ - (double)cornerX) / 2.0;
        double y = (pos.f_82480_ - (double)cornerY) / 2.0;
        double z = (pos.f_82481_ - (double)cornerZ) / 2.0;
        ColorRGB8 c00 = this.linearInterpolation(c000, c100, x);
        ColorRGB8 c01 = this.linearInterpolation(c001, c101, x);
        ColorRGB8 c11 = this.linearInterpolation(c011, c111, x);
        ColorRGB8 c10 = this.linearInterpolation(c010, c110, x);
        ColorRGB8 c0 = this.linearInterpolation(c00, c10, y);
        ColorRGB8 c1 = this.linearInterpolation(c01, c11, y);
        return this.linearInterpolation(c0, c1, z);
    }

    private ColorRGB8 linearInterpolation(ColorRGB8 a, ColorRGB8 b, double x) {
        if (a.isZero()) {
            return b;
        }
        if (b.isZero()) {
            return a;
        }
        return a.mul(1.0 - x).add(b.mul(x));
    }

    private void requestLightPropagation(BlockPos originPos, ColorRGB4 lightColor, boolean increase, boolean force) {
        if (increase) {
            this.propagateIncreases.add(new LightUpdateRequest(originPos, lightColor, force));
        } else {
            this.propagateDecreases.add(new LightUpdateRequest(originPos, lightColor, force));
        }
    }

    private void propagateIncreases() {
        LevelAccessor level = this.clientAccessor.getLevel();
        if (level == null) {
            return;
        }
        while (!this.propagateIncreases.isEmpty()) {
            LightUpdateRequest request = this.propagateIncreases.poll();
            ColorRGB4 oldLightColor = this.storage.getEntry(request.blockPos);
            if (oldLightColor == null) continue;
            ColorRGB4 newLightColor = ColorRGB4.fromRGB4(Math.max(oldLightColor.red4, request.lightColor.red4), Math.max(oldLightColor.green4, request.lightColor.green4), Math.max(oldLightColor.blue4, request.lightColor.blue4));
            if (!request.force && newLightColor.red4 == oldLightColor.red4 && newLightColor.green4 == oldLightColor.green4 && newLightColor.blue4 == oldLightColor.blue4) continue;
            this.setLightColor(request.blockPos, newLightColor);
            for (Direction direction : Direction.values()) {
                BlockPos neighbourPos = request.blockPos.m_121945_(direction);
                if (!level.isInBounds(neighbourPos)) continue;
                BlockStateAccessor neighbourState = level.getBlockState(neighbourPos);
                int lightBlocked = Math.max(1, neighbourState.getLightBlock(level, neighbourPos));
                ColorRGB4 coloredLightTransmittance = Config.getColoredLightTransmittance(level, neighbourPos, neighbourState);
                ColorRGB4 neighbourLightColor = ColorRGB4.fromRGB4(MathExt.clamp(request.lightColor.red4 - lightBlocked, 0, coloredLightTransmittance.red4), MathExt.clamp(request.lightColor.green4 - lightBlocked, 0, coloredLightTransmittance.green4), MathExt.clamp(request.lightColor.blue4 - lightBlocked, 0, coloredLightTransmittance.blue4));
                if (neighbourLightColor.red4 == 0 && neighbourLightColor.green4 == 0 && neighbourLightColor.blue4 == 0) continue;
                this.requestLightPropagation(neighbourPos, neighbourLightColor, true, false);
            }
        }
    }

    private void propagateDecreases() {
        LevelAccessor level = this.clientAccessor.getLevel();
        if (level == null) {
            return;
        }
        while (!this.propagateDecreases.isEmpty()) {
            LightUpdateRequest request = this.propagateDecreases.poll();
            ColorRGB4 oldLightColor = this.storage.getEntry(request.blockPos);
            if (oldLightColor == null || !request.force && oldLightColor.red4 == 0 && oldLightColor.green4 == 0 && oldLightColor.blue4 == 0) continue;
            this.setLightColor(request.blockPos, ColorRGB4.fromRGB4(0, 0, 0));
            if (Config.getEmissionBrightness(level, request.blockPos) > 0) {
                this.requestLightPropagation(request.blockPos, Config.getColorEmission(level, request.blockPos), true, false);
            }
            ColorRGB4 neighbourLightDecrease = ColorRGB4.fromRGB4(Math.max(0, request.lightColor.red4 - 1), Math.max(0, request.lightColor.green4 - 1), Math.max(0, request.lightColor.blue4 - 1));
            boolean repropagateNeighbours = neighbourLightDecrease.red4 == 0 && neighbourLightDecrease.green4 == 0 && neighbourLightDecrease.blue4 == 0;
            for (Direction direction : Direction.values()) {
                BlockPos neighbourPos = request.blockPos.m_121945_(direction);
                if (!level.isInBounds(neighbourPos)) continue;
                if (!repropagateNeighbours) {
                    this.requestLightPropagation(neighbourPos, neighbourLightDecrease, false, false);
                    continue;
                }
                ColorRGB4 neighbourLightColor = this.storage.getEntry(neighbourPos);
                if (neighbourLightColor == null || neighbourLightColor.red4 == 0 && neighbourLightColor.green4 == 0 && neighbourLightColor.blue4 == 0) continue;
                this.requestLightPropagation(neighbourPos, neighbourLightColor, true, true);
            }
        }
    }

    public void requestLightPullIn(BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighbourPos = blockPos.m_121945_(direction);
            ColorRGB4 neighbourLight = this.storage.getEntry(neighbourPos);
            if (neighbourLight == null || neighbourLight.red4 == 0 && neighbourLight.green4 == 0 && neighbourLight.blue4 == 0) continue;
            this.requestLightPropagation(neighbourPos, neighbourLight, true, true);
        }
    }

    public void onBlockLightPropertiesChanged(BlockPos blockPos) {
        LevelAccessor level = this.clientAccessor.getLevel();
        if (level == null) {
            return;
        }
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)blockPos);
        if (!ColoredLightEngine.getInstance().isChunkAndNeighboursLoaded(sectionPos.m_123170_(), sectionPos.m_123222_())) {
            return;
        }
        ColorRGB4 lightColor = this.storage.getEntry(blockPos);
        assert (lightColor != null);
        if (lightColor.red4 == 0 && lightColor.green4 == 0 && lightColor.blue4 == 0) {
            this.requestLightPullIn(blockPos);
        } else {
            this.requestLightPropagation(blockPos, lightColor, false, false);
        }
        if (Config.getEmissionBrightness(level, blockPos) > 0) {
            this.requestLightPropagation(blockPos, Config.getColorEmission(level, blockPos), true, false);
        }
    }

    public void runLightUpdates() {
        LevelAccessor level = this.clientAccessor.getLevel();
        if (level == null) {
            return;
        }
        this.propagateDecreases();
        this.propagateIncreases();
        Iterator iterator = this.dirtySections.iterator();
        while (iterator.hasNext()) {
            SectionPos sectionPos = SectionPos.m_123184_((long)((Long)iterator.next()));
            level.setSectionDirtyWithNeighbours(sectionPos.m_123170_(), sectionPos.m_123206_(), sectionPos.m_123222_());
            iterator.remove();
        }
    }

    private void setLightColor(BlockPos blockPos, ColorRGB4 color) {
        this.storage.setEntry(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), color);
        this.dirtySections.add(SectionPos.m_175568_((BlockPos)blockPos));
    }

    public void onChunkLoad(ChunkPos chunkPos) {
        LevelAccessor level = this.clientAccessor.getLevel();
        if (level == null) {
            return;
        }
        for (int i = 0; i < level.getSectionsCount(); ++i) {
            int y = level.getMinSectionY() + i;
            this.storage.addSection(SectionPos.m_123209_((int)chunkPos.f_45578_, (int)y, (int)chunkPos.f_45579_));
        }
        for (int x = chunkPos.f_45578_ - 1; x <= chunkPos.f_45578_ + 1; ++x) {
            for (int z = chunkPos.f_45579_ - 1; z <= chunkPos.f_45579_ + 1; ++z) {
                if (!this.isChunkAndNeighboursLoaded(x, z)) continue;
                ChunkPos neighbourPos = new ChunkPos(x, z);
                this.newChunks.add(neighbourPos);
                this.fullyLoadedChunks.add(neighbourPos);
            }
        }
    }

    public void onChunkUnload(ChunkPos chunkPos) {
        LevelAccessor level = this.clientAccessor.getLevel();
        if (level == null) {
            return;
        }
        this.newChunks.remove(chunkPos);
        for (int i = 0; i < level.getSectionsCount(); ++i) {
            int y = level.getMinSectionY() + i;
            this.storage.removeSection(SectionPos.m_123209_((int)chunkPos.f_45578_, (int)y, (int)chunkPos.f_45579_));
        }
        this.fullyLoadedChunks.remove(chunkPos);
    }

    public void onLevelUnload() {
        this.newChunks.clear();
        this.fullyLoadedChunks.clear();
        this.storage.clear();
    }

    public void refreshLevel() {
        LevelAccessor level = this.clientAccessor.getLevel();
        if (level == null) {
            return;
        }
        for (ChunkPos chunk : this.fullyLoadedChunks) {
            for (int i = 0; i < level.getSectionsCount(); ++i) {
                int y = level.getMinSectionY() + i;
                this.storage.getSection(SectionPos.m_123209_((int)chunk.f_45578_, (int)y, (int)chunk.f_45579_)).clear();
            }
        }
        this.newChunks.addAll(this.fullyLoadedChunks);
    }

    public boolean isChunkLoaded(int x, int z) {
        LevelAccessor level = this.clientAccessor.getLevel();
        if (level == null) {
            return false;
        }
        return this.storage.containsSection(SectionPos.m_123209_((int)x, (int)level.getMinSectionY(), (int)z));
    }

    public boolean isChunkAndNeighboursLoaded(int x, int z) {
        LevelAccessor level = this.clientAccessor.getLevel();
        if (level == null) {
            return false;
        }
        for (int ox = x - 1; ox <= x + 1; ++ox) {
            for (int oz = z - 1; oz <= z + 1; ++oz) {
                if (this.storage.containsSection(SectionPos.m_123209_((int)ox, (int)level.getMinSectionY(), (int)oz))) continue;
                return false;
            }
        }
        return true;
    }

    private class PropagateLightInNewChunks
    implements Runnable {
        private static int MIN_WAIT = 10;
        private int nextWait = 0;

        private PropagateLightInNewChunks() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(Math.max(MIN_WAIT, this.nextWait));
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                this.doTask();
            }
        }

        private void doTask() {
            if (ColoredLightEngine.this.newChunks.isEmpty()) {
                return;
            }
            if (!ColoredLightEngine.this.propagateIncreases.isEmpty()) {
                return;
            }
            LevelAccessor level = ColoredLightEngine.this.clientAccessor.getLevel();
            if (level == null) {
                return;
            }
            PlayerAccessor playerAccessor = ColoredLightEngine.this.clientAccessor.getPlayer();
            if (playerAccessor == null) {
                return;
            }
            Iterator iterator = ColoredLightEngine.this.newChunks.iterator();
            int minDistance = Integer.MAX_VALUE;
            ChunkPos nearestChunkPos = null;
            while (iterator.hasNext()) {
                ChunkPos chunkPos = (ChunkPos)iterator.next();
                int distance = chunkPos.m_45594_(playerAccessor.getPlayerChunkPos());
                if (distance >= minDistance) continue;
                minDistance = distance;
                nearestChunkPos = chunkPos;
            }
            ColoredLightEngine.this.newChunks.remove(nearestChunkPos);
            AtomicInteger lightSources = new AtomicInteger();
            level.findLightSources(nearestChunkPos, blockPos -> {
                ColoredLightEngine.this.requestLightPropagation((BlockPos)blockPos, Config.getColorEmission(level, blockPos), true, false);
                lightSources.incrementAndGet();
            });
            this.nextWait = lightSources.get() / 50;
        }
    }

    private static class LightUpdateRequest {
        BlockPos blockPos;
        ColorRGB4 lightColor;
        boolean force;

        public LightUpdateRequest(BlockPos blockPos, ColorRGB4 lightColor, boolean force) {
            this.blockPos = blockPos;
            this.lightColor = lightColor;
            this.force = force;
        }
    }
}

