/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.common.util;

import me.erykczy.colorfullighting.common.util.ColorRGB8;

public class ColorRGB4 {
    public static final int SIZE = 12;
    public int red4;
    public int green4;
    public int blue4;

    public static ColorRGB4 fromRGB8(ColorRGB8 other) {
        return ColorRGB4.fromRGB8(other.red, other.green, other.blue);
    }

    public static ColorRGB4 fromRGB8(int r, int g, int b) {
        return ColorRGB4.fromRGB4(r / 17, g / 17, b / 17);
    }

    public static ColorRGB4 fromRGB4(int r, int g, int b) {
        return new ColorRGB4(r, g, b);
    }

    public static ColorRGB4 fromRGBFloat(float r, float g, float b) {
        return new ColorRGB4((int)(r * 15.0f), (int)(g * 15.0f), (int)(b * 15.0f));
    }

    private ColorRGB4(int r4, int g4, int b4) {
        this.red4 = r4;
        this.green4 = g4;
        this.blue4 = b4;
    }

    public boolean isInValidState() {
        return this.red4 >= 0 && this.red4 < 16 && this.green4 >= 0 && this.green4 < 16 && this.blue4 >= 0 && this.blue4 < 16;
    }

    public ColorRGB4 mul(float scalar) {
        return new ColorRGB4((int)((float)this.red4 * scalar), (int)((float)this.green4 * scalar), (int)((float)this.blue4 * scalar));
    }

    public String toString() {
        return "ColorRGB4[" + this.red4 + ", " + this.green4 + ", " + this.blue4 + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColorRGB4)) return false;
        ColorRGB4 other = (ColorRGB4)obj;
        if (other.red4 != this.red4) return false;
        if (other.green4 != this.green4) return false;
        if (other.blue4 != this.blue4) return false;
        return true;
    }
}

