/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.mixin.compat.sodium;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.erykczy.colorfullighting.common.ColoredLightEngine;
import me.erykczy.colorfullighting.common.util.ColorRGB8;
import me.erykczy.colorfullighting.common.util.TintingBufferSource;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FallingBlockRenderer.class})
public abstract class FallingBlockRendererMixin {
    @Unique
    private static final ThreadLocal<float[]> CL_mul = new ThreadLocal();

    @Unique
    private static boolean cl$skip() {
        return ModList.get().isLoaded("embeddium");
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/item/FallingBlockEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    private void cl$begin(FallingBlockEntity e, float yaw, float pt, PoseStack pose, MultiBufferSource buffers, int packedLight, CallbackInfo ci) {
        if (!FallingBlockRendererMixin.cl$skip() || e == null) {
            CL_mul.remove();
            return;
        }
        ColoredLightEngine eng = ColoredLightEngine.getInstance();
        if (eng == null) {
            CL_mul.remove();
            return;
        }
        int bx = (int)Math.floor(e.m_20185_());
        int by = (int)Math.floor(e.m_20186_());
        int bz = (int)Math.floor(e.m_20189_());
        Vec3 sample = Vec3.m_82512_((Vec3i)new BlockPos(bx, by, bz));
        ColorRGB8 c = eng.sampleTrilinearLightColor(sample);
        int r = c.red & 0xFF;
        int g = c.green & 0xFF;
        int b = c.blue & 0xFF;
        int m = Math.max(r, Math.max(g, b));
        if (m == 0) {
            CL_mul.remove();
            return;
        }
        float k = (float)m / 255.0f;
        float mr = 1.0f + k * ((float)r / 255.0f - 1.0f);
        float mg = 1.0f + k * ((float)g / 255.0f - 1.0f);
        float mb = 1.0f + k * ((float)b / 255.0f - 1.0f);
        CL_mul.set(new float[]{mr, mg, mb});
    }

    @Redirect(method={"render(Lnet/minecraft/world/entity/item/FallingBlockEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;"))
    private VertexConsumer cl$tintedBuffer(MultiBufferSource buffers, RenderType rt) {
        float[] mul = CL_mul.get();
        if (mul != null) {
            buffers = new TintingBufferSource(buffers, mul[0], mul[1], mul[2]);
        }
        return buffers.m_6299_(rt);
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/item/FallingBlockEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="RETURN")})
    private void cl$end(FallingBlockEntity e, float yaw, float pt, PoseStack pose, MultiBufferSource buffers, int packedLight, CallbackInfo ci) {
        CL_mul.remove();
    }
}

