/*
 * Decompiled with CFR 0.152.
 */
package me.erykczy.colorfullighting.mixin.compat.sodium;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.erykczy.colorfullighting.common.ColoredLightEngine;
import me.erykczy.colorfullighting.common.util.ColorRGB8;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public abstract class SodiumCompatFirstPersonHandItemsMixin {
    @Unique
    private static final ThreadLocal<float[]> colorfullighting$prevShaderColor = new ThreadLocal();

    @Unique
    private static void colorfullighting$begin(AbstractClientPlayer player, float partialTick) {
        ColoredLightEngine eng = ColoredLightEngine.getInstance();
        if (eng == null || player == null) {
            return;
        }
        Vec3 eye = player.m_20299_(partialTick);
        ColorRGB8 c = eng.sampleTrilinearLightColor(new Vec3(eye.f_82479_, eye.f_82480_, eye.f_82481_));
        int rc = c.red & 0xFF;
        int gc = c.green & 0xFF;
        int bc = c.blue & 0xFF;
        int maxc = Math.max(rc, Math.max(gc, bc));
        if (maxc == 0) {
            return;
        }
        float k = (float)maxc / 255.0f;
        float mr = 1.0f + k * ((float)rc / 255.0f - 1.0f);
        float mg = 1.0f + k * ((float)gc / 255.0f - 1.0f);
        float mb = 1.0f + k * ((float)bc / 255.0f - 1.0f);
        float[] prev = (float[])RenderSystem.getShaderColor().clone();
        colorfullighting$prevShaderColor.set(prev);
        RenderSystem.setShaderColor((float)(prev[0] * mr), (float)(prev[1] * mg), (float)(prev[2] * mb), (float)prev[3]);
    }

    @Unique
    private static void colorfullighting$end() {
        float[] prev = colorfullighting$prevShaderColor.get();
        if (prev != null) {
            RenderSystem.setShaderColor((float)prev[0], (float)prev[1], (float)prev[2], (float)prev[3]);
            colorfullighting$prevShaderColor.remove();
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Inject(method={"renderHandsWithItems(FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/player/LocalPlayer;I)V"}, at={@At(value="HEAD")})
    private void colorfullighting$beginHandsWithItems(float partialTick, PoseStack poseStack, MultiBufferSource.BufferSource buffers, LocalPlayer player, int packedLight, CallbackInfo ci) {
        SodiumCompatFirstPersonHandItemsMixin.colorfullighting$begin((AbstractClientPlayer)player, partialTick);
    }

    @Inject(method={"renderHandsWithItems(FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lnet/minecraft/client/player/LocalPlayer;I)V"}, at={@At(value="RETURN")})
    private void colorfullighting$endHandsWithItems(float partialTick, PoseStack poseStack, MultiBufferSource.BufferSource buffers, LocalPlayer player, int packedLight, CallbackInfo ci) {
        SodiumCompatFirstPersonHandItemsMixin.colorfullighting$end();
    }

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    private void colorfullighting$beginArmWithItem(AbstractClientPlayer player, float partialTick, float pitch, InteractionHand hand, float swingProgress, ItemStack stack, float equipProgress, PoseStack poseStack, MultiBufferSource buffers, int packedLight, CallbackInfo ci) {
        SodiumCompatFirstPersonHandItemsMixin.colorfullighting$begin(player, partialTick);
    }

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="RETURN")})
    private void colorfullighting$endArmWithItem(AbstractClientPlayer player, float partialTick, float pitch, InteractionHand hand, float swingProgress, ItemStack stack, float equipProgress, PoseStack poseStack, MultiBufferSource buffers, int packedLight, CallbackInfo ci) {
        SodiumCompatFirstPersonHandItemsMixin.colorfullighting$end();
    }

    @Inject(method={"renderPlayerArm(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IFFLnet/minecraft/world/entity/HumanoidArm;)V"}, at={@At(value="HEAD")})
    private void colorfullighting$beginPlayerArm(PoseStack poseStack, MultiBufferSource buffers, int packedLight, float partialTick, float swing, HumanoidArm arm, CallbackInfo ci) {
        SodiumCompatFirstPersonHandItemsMixin.colorfullighting$begin(null, partialTick);
    }

    @Inject(method={"renderPlayerArm(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IFFLnet/minecraft/world/entity/HumanoidArm;)V"}, at={@At(value="RETURN")})
    private void colorfullighting$endPlayerArm(PoseStack poseStack, MultiBufferSource buffers, int packedLight, float partialTick, float swing, HumanoidArm arm, CallbackInfo ci) {
        SodiumCompatFirstPersonHandItemsMixin.colorfullighting$end();
    }
}

